/*
 * Decompiled with CFR 0.152.
 */
package f1nal.essentials.config;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;

public final class TagConfig {
    public final String text;
    public final class_124 color;
    public final class_124 bracketColor;
    public final boolean bold;

    private TagConfig(String text, class_124 color, class_124 bracketColor, boolean bold) {
        this.text = text;
        this.color = color;
        this.bracketColor = bracketColor;
        this.bold = bold;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TagConfig loadOrDefaults() {
        Path cfg = FabricLoader.getInstance().getConfigDir().resolve("essentials.yaml");
        if (!Files.exists(cfg, new LinkOption[0])) {
            return TagConfig.defaults();
        }
        try (BufferedReader reader = Files.newBufferedReader(cfg, StandardCharsets.UTF_8);){
            Boolean boldObj;
            Yaml yaml = new Yaml(new LoaderOptions());
            Object root = yaml.load((Reader)reader);
            if (!(root instanceof Map)) {
                TagConfig tagConfig = TagConfig.defaults();
                return tagConfig;
            }
            Map map = (Map)root;
            Object tagObj = map.get("tag");
            if (!(tagObj instanceof Map)) {
                TagConfig tagConfig = TagConfig.defaults();
                return tagConfig;
            }
            Map tag = (Map)tagObj;
            String text = TagConfig.coerceString(tag.get("text"), null);
            String colorStr = TagConfig.coerceString(tag.get("color"), null);
            String bracketColorStr = TagConfig.coerceString(tag.get("bracketColor"), null);
            Boolean bl = boldObj = tag.get("bold") instanceof Boolean ? (Boolean)tag.get("bold") : null;
            if (text == null || colorStr == null || bracketColorStr == null || boldObj == null) {
                TagConfig tagConfig = TagConfig.defaults();
                return tagConfig;
            }
            class_124 color = TagConfig.parseFormatting(colorStr, null);
            class_124 bracketColor = TagConfig.parseFormatting(bracketColorStr, null);
            if (color == null || bracketColor == null) {
                TagConfig tagConfig = TagConfig.defaults();
                return tagConfig;
            }
            TagConfig tagConfig = new TagConfig(text, color, bracketColor, boldObj);
            return tagConfig;
        }
        catch (IOException e) {
            return TagConfig.defaults();
        }
    }

    private static TagConfig defaults() {
        return new TagConfig("Essentials", class_124.field_1064, class_124.field_1063, true);
    }

    private static String coerceString(Object value, String def) {
        String s;
        return value instanceof String ? (s = (String)value) : def;
    }

    private static boolean coerceBoolean(Object value, boolean def) {
        String s;
        String n;
        if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            return b;
        }
        if (value instanceof String && ((n = (s = (String)value).trim().toLowerCase(Locale.ROOT)).equals("true") || n.equals("false"))) {
            return Boolean.parseBoolean(n);
        }
        return def;
    }

    private static class_124 parseFormatting(String name, class_124 def) {
        if (name == null || name.trim().isEmpty()) {
            return def;
        }
        try {
            return class_124.valueOf((String)name.trim().toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

