/*
 * Decompiled with CFR 0.152.
 */
package f1nal.essentials.config;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;

public final class TpaConfig {
    private static final int DEFAULT_TIMEOUT_SECONDS = 60;
    private static final int DEFAULT_COOLDOWN_SECONDS = 10;
    public final int timeoutSeconds;
    public final int cooldownSeconds;
    private static TpaConfig INSTANCE;

    private TpaConfig(int timeoutSeconds, int cooldownSeconds) {
        this.timeoutSeconds = timeoutSeconds;
        this.cooldownSeconds = cooldownSeconds;
    }

    public static synchronized TpaConfig get() {
        if (INSTANCE == null) {
            INSTANCE = TpaConfig.loadOrDefaults();
        }
        return INSTANCE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static TpaConfig loadOrDefaults() {
        Path cfg = FabricLoader.getInstance().getConfigDir().resolve("essentials.yaml");
        if (!Files.exists(cfg, new LinkOption[0])) {
            return TpaConfig.defaults();
        }
        try (BufferedReader reader = Files.newBufferedReader(cfg, StandardCharsets.UTF_8);){
            Yaml yaml = new Yaml(new LoaderOptions());
            Object root = yaml.load((Reader)reader);
            if (!(root instanceof Map)) {
                TpaConfig tpaConfig = TpaConfig.defaults();
                return tpaConfig;
            }
            Map map = (Map)root;
            Object tpaObj = map.get("tpa");
            if (!(tpaObj instanceof Map)) {
                TpaConfig tpaConfig = TpaConfig.defaults();
                return tpaConfig;
            }
            Map tpa = (Map)tpaObj;
            int timeout = TpaConfig.coerceInt(tpa.get("timeout_seconds"), 60);
            int cooldown = TpaConfig.coerceInt(tpa.get("cooldown_seconds"), 10);
            if (timeout < 1) {
                timeout = 60;
            }
            if (cooldown < 0) {
                cooldown = 10;
            }
            TpaConfig tpaConfig = new TpaConfig(timeout, cooldown);
            return tpaConfig;
        }
        catch (IOException e) {
            return TpaConfig.defaults();
        }
    }

    private static TpaConfig defaults() {
        return new TpaConfig(60, 10);
    }

    private static int coerceInt(Object value, int def) {
        if (value instanceof Number) {
            Number n = (Number)value;
            return n.intValue();
        }
        if (value instanceof String) {
            String s = (String)value;
            try {
                return Integer.parseInt(s.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return def;
    }
}

