/*
 * Decompiled with CFR 0.152.
 */
package f1nal.essentials.tpa;

import f1nal.essentials.config.TpaConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public final class TpaManager {
    private static final Map<UUID, Request> outgoingBySender = new ConcurrentHashMap<UUID, Request>();
    private static final Map<UUID, List<Request>> incomingByTarget = new ConcurrentHashMap<UUID, List<Request>>();
    private static final Map<UUID, Long> cancelCooldownUntil = new ConcurrentHashMap<UUID, Long>();

    private TpaManager() {
    }

    private static long requestTtlMillis() {
        return (long)Math.max(1, TpaConfig.get().timeoutSeconds) * 1000L;
    }

    private static long cancelCooldownMillis() {
        int s = TpaConfig.get().cooldownSeconds;
        if (s < 0) {
            s = 0;
        }
        return (long)s * 1000L;
    }

    public static Optional<Long> getSecondsLeftOnCancelCooldown(class_3222 sender) {
        long now = System.currentTimeMillis();
        Long until = cancelCooldownUntil.get(sender.method_5667());
        if (until == null) {
            return Optional.empty();
        }
        if (until <= now) {
            cancelCooldownUntil.remove(sender.method_5667());
            return Optional.empty();
        }
        long seconds = (until - now + 999L) / 1000L;
        return Optional.of(seconds);
    }

    public static synchronized boolean createRequest(class_3222 sender, class_3222 target, Type type) {
        TpaManager.cleanupExpired();
        UUID s = sender.method_5667();
        UUID t = target.method_5667();
        if (outgoingBySender.containsKey(s)) {
            return false;
        }
        long now = System.currentTimeMillis();
        Long cooldown = cancelCooldownUntil.get(s);
        if (cooldown != null && cooldown > now) {
            return false;
        }
        Request req = new Request(s, t, type, now, now + TpaManager.requestTtlMillis());
        outgoingBySender.put(s, req);
        incomingByTarget.computeIfAbsent(t, k -> new ArrayList()).add(req);
        return true;
    }

    public static synchronized Optional<Request> findIncomingFor(class_3222 target, @Nullable class_3222 from) {
        TpaManager.cleanupExpired();
        List list = incomingByTarget.getOrDefault(target.method_5667(), Collections.emptyList());
        if (list.isEmpty()) {
            return Optional.empty();
        }
        if (from == null) {
            long now = System.currentTimeMillis();
            return list.stream().filter(r -> !r.isExpired(now)).max(Comparator.comparingLong(r -> r.createdAtMillis));
        }
        UUID fromId = from.method_5667();
        return list.stream().filter(r -> r.sender.equals(fromId)).findFirst();
    }

    public static synchronized Optional<Request> accept(class_3222 target, @Nullable class_3222 from) {
        Optional<Request> reqOpt = TpaManager.findIncomingFor(target, from);
        reqOpt.ifPresent(TpaManager::remove);
        return reqOpt;
    }

    public static synchronized Optional<Request> deny(class_3222 target, @Nullable class_3222 from) {
        Optional<Request> reqOpt = TpaManager.findIncomingFor(target, from);
        reqOpt.ifPresent(TpaManager::remove);
        return reqOpt;
    }

    public static synchronized boolean cancel(class_3222 sender) {
        TpaManager.cleanupExpired();
        UUID s = sender.method_5667();
        Request req = outgoingBySender.remove(s);
        if (req == null) {
            return false;
        }
        List<Request> list = incomingByTarget.get(req.target);
        if (list != null) {
            list.removeIf(r -> r.sender.equals(s));
            if (list.isEmpty()) {
                incomingByTarget.remove(req.target);
            }
        }
        cancelCooldownUntil.put(s, System.currentTimeMillis() + TpaManager.cancelCooldownMillis());
        return true;
    }

    private static void remove(Request req) {
        outgoingBySender.remove(req.sender);
        List<Request> list = incomingByTarget.get(req.target);
        if (list != null) {
            list.removeIf(r -> r.sender.equals(req.sender));
            if (list.isEmpty()) {
                incomingByTarget.remove(req.target);
            }
        }
    }

    public static synchronized void cleanupExpired() {
        long now = System.currentTimeMillis();
        Iterator<Map.Entry<UUID, Request>> it = outgoingBySender.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<UUID, Request> e = it.next();
            if (!e.getValue().isExpired(now)) continue;
            it.remove();
        }
        Iterator<Map.Entry<UUID, List<Request>>> it2 = incomingByTarget.entrySet().iterator();
        while (it2.hasNext()) {
            Map.Entry<UUID, List<Request>> e = it2.next();
            e.getValue().removeIf(r -> r.isExpired(now));
            if (!e.getValue().isEmpty()) continue;
            it2.remove();
        }
        cancelCooldownUntil.entrySet().removeIf(en -> (Long)en.getValue() <= now);
    }

    public static final class Request {
        public final UUID sender;
        public final UUID target;
        public final Type type;
        public final long createdAtMillis;
        public final long expiresAtMillis;

        public Request(UUID sender, UUID target, Type type, long createdAtMillis, long expiresAtMillis) {
            this.sender = sender;
            this.target = target;
            this.type = type;
            this.createdAtMillis = createdAtMillis;
            this.expiresAtMillis = expiresAtMillis;
        }

        public boolean isExpired(long now) {
            return now >= this.expiresAtMillis;
        }
    }

    public static enum Type {
        TPA,
        TPA_HERE;

    }
}

