/*
 * Decompiled with CFR 0.152.
 */
package f1nal.essentials.config;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;

public final class CommandConfig {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, CommandSettings> loadCommandSettings() {
        Path cfg = FabricLoader.getInstance().getConfigDir().resolve("essentials.yaml");
        if (!Files.exists(cfg, new LinkOption[0])) {
            return CommandConfig.defaults();
        }
        try (BufferedReader reader = Files.newBufferedReader(cfg, StandardCharsets.UTF_8);){
            Yaml yaml = new Yaml(new LoaderOptions());
            Object root = yaml.load((Reader)reader);
            if (!(root instanceof Map)) {
                Map<String, CommandSettings> map = CommandConfig.defaults();
                return map;
            }
            Map map = (Map)root;
            Object commandsObj = map.get("commands");
            if (!(commandsObj instanceof Map)) {
                Map<String, CommandSettings> map2 = CommandConfig.defaults();
                return map2;
            }
            Map commands = (Map)commandsObj;
            HashMap<String, CommandSettings> result = new HashMap<String, CommandSettings>();
            for (Map.Entry entry : commands.entrySet()) {
                String access;
                String commandName = entry.getKey().toString();
                Object configObj = entry.getValue();
                if (!(configObj instanceof Map)) continue;
                Map config = (Map)configObj;
                Boolean enabled = config.get("enabled") instanceof Boolean ? (Boolean)config.get("enabled") : null;
                String string = access = config.get("access") instanceof String ? (String)config.get("access") : null;
                if (enabled == null || access == null) continue;
                result.put(commandName, new CommandSettings(enabled, access));
            }
            HashMap<String, CommandSettings> hashMap = result;
            return hashMap;
        }
        catch (IOException e) {
            return CommandConfig.defaults();
        }
    }

    private static Map<String, CommandSettings> defaults() {
        HashMap<String, CommandSettings> defaults = new HashMap<String, CommandSettings>();
        defaults.put("repair", new CommandSettings(true, "op"));
        defaults.put("heal", new CommandSettings(true, "op"));
        defaults.put("feed", new CommandSettings(true, "op"));
        defaults.put("flight", new CommandSettings(true, "op"));
        defaults.put("disposal", new CommandSettings(true, "all"));
        return defaults;
    }

    public record CommandSettings(boolean enabled, String access) {
        public Predicate<class_2168> getPermissionRequirement() {
            return switch (this.access.toLowerCase()) {
                case "op" -> source -> source.method_9259(2);
                case "all" -> source -> true;
                default -> source -> source.method_9259(2);
            };
        }
    }
}

