/*
 * Decompiled with CFR 0.152.
 */
package f1nal.essentials;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import f1nal.essentials.DisposalInventory;
import f1nal.essentials.Messages;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1263;
import net.minecraft.class_1661;
import net.minecraft.class_1707;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_7157;
import net.minecraft.class_747;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Essentials
implements ModInitializer {
    public static final String MOD_ID = "essentials";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"essentials");

    public void onInitialize() {
        this.registerCommands();
        LOGGER.info("Essentials initialized");
    }

    private void registerCommands() {
        CommandRegistrationCallback.EVENT.register(this::registerRepairCommand);
        CommandRegistrationCallback.EVENT.register(this::registerHealCommand);
        CommandRegistrationCallback.EVENT.register(this::registerFeedCommand);
        CommandRegistrationCallback.EVENT.register(this::registerFlightCommand);
        CommandRegistrationCallback.EVENT.register(this::registerDisposalCommand);
    }

    private void registerRepairCommand(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        LiteralArgumentBuilder root = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"repair").requires(source -> source.method_9259(2))).executes(ctx -> this.repair((class_2168)ctx.getSource(), ((class_2168)ctx.getSource()).method_44023()))).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).executes(ctx -> this.repair((class_2168)ctx.getSource(), class_2186.method_9315((CommandContext)ctx, (String)"target"))));
        dispatcher.register(root);
    }

    private int repair(class_2168 source, class_3222 target) {
        if (target == null) {
            source.method_9213(Messages.error("You must be a player to use this command."));
            return 0;
        }
        class_1799 stack = target.method_6047();
        if (stack.method_7960()) {
            source.method_9213(Messages.error(target.method_5477().getString() + " has an empty main hand."));
            return 0;
        }
        if (!stack.method_7963()) {
            source.method_9226(() -> Messages.warning("The item in main hand is not damageable: " + stack.method_7964().getString()), false);
            return 1;
        }
        stack.method_7974(0);
        if (source.method_9228() == target) {
            source.method_9226(() -> Messages.info("Repaired main-hand item: " + stack.method_7964().getString()), false);
        } else {
            source.method_9226(() -> Messages.info("Repaired " + target.method_5477().getString() + "'s main-hand item: " + stack.method_7964().getString()), true);
            target.method_64398(Messages.info("Main-hand item was repaired by " + source.method_9214() + "."));
        }
        return 1;
    }

    private void registerHealCommand(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        LiteralArgumentBuilder root = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"heal").requires(source -> source.method_9259(2))).executes(ctx -> this.heal((class_2168)ctx.getSource(), ((class_2168)ctx.getSource()).method_44023()))).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).executes(ctx -> this.heal((class_2168)ctx.getSource(), class_2186.method_9315((CommandContext)ctx, (String)"target"))));
        dispatcher.register(root);
    }

    private int heal(class_2168 source, class_3222 target) {
        if (target == null) {
            source.method_9213(Messages.error("You must be a player to use this command."));
            return 0;
        }
        float maxHealth = target.method_6063();
        target.method_6033(maxHealth);
        target.method_7344().method_7580(20);
        target.method_7344().method_7581(20.0f);
        if (source.method_9228() == target) {
            source.method_9226(() -> Messages.info("Healed to full health (" + maxHealth + ")"), false);
        } else {
            source.method_9226(() -> Messages.info("Healed " + target.method_5477().getString() + " to full health (" + maxHealth + ")"), true);
            target.method_64398(Messages.info("Healed to full health by " + source.method_9214() + "."));
        }
        return 1;
    }

    private void registerFeedCommand(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        LiteralArgumentBuilder root = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"feed").requires(source -> source.method_9259(2))).executes(ctx -> this.feed((class_2168)ctx.getSource(), ((class_2168)ctx.getSource()).method_44023()))).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).executes(ctx -> this.feed((class_2168)ctx.getSource(), class_2186.method_9315((CommandContext)ctx, (String)"target"))));
        dispatcher.register(root);
    }

    private int feed(class_2168 source, class_3222 target) {
        if (target == null) {
            source.method_9213(Messages.error("You must be a player to use this command."));
            return 0;
        }
        target.method_7344().method_7580(20);
        target.method_7344().method_7581(20.0f);
        if (source.method_9228() == target) {
            source.method_9226(() -> Messages.info("Fed to full hunger and saturation."), false);
        } else {
            source.method_9226(() -> Messages.info("Fed " + target.method_5477().getString() + " to full hunger and saturation."), true);
            target.method_64398(Messages.info("Fed to full hunger and saturation by " + source.method_9214() + "."));
        }
        return 1;
    }

    private void registerFlightCommand(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        LiteralArgumentBuilder root = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"flight").requires(source -> source.method_9259(2))).executes(ctx -> this.toggleFlight((class_2168)ctx.getSource(), ((class_2168)ctx.getSource()).method_44023()))).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).executes(ctx -> this.toggleFlight((class_2168)ctx.getSource(), class_2186.method_9315((CommandContext)ctx, (String)"target"))));
        dispatcher.register(root);
    }

    private int toggleFlight(class_2168 source, class_3222 target) {
        boolean enable;
        if (target == null) {
            source.method_9213(Messages.error("You must be a player to use this command."));
            return 0;
        }
        if (target.method_68878() || target.method_7325()) {
            if (source.method_9228() == target) {
                source.method_9226(() -> Messages.info("Gamemode already allows flight."), false);
            } else {
                source.method_9226(() -> Messages.info(target.method_5477().getString() + "'s gamemode already allows flight."), true);
            }
            return 1;
        }
        target.method_31549().field_7478 = enable = !target.method_31549().field_7478;
        target.method_31549().field_7479 = enable;
        target.method_7355();
        if (source.method_9228() == target) {
            source.method_9226(() -> enable ? Messages.success("Flight enabled.") : Messages.info("Flight disabled."), false);
        } else {
            source.method_9226(() -> enable ? Messages.success("Enabled " + target.method_5477().getString() + "'s flight.") : Messages.warning("Disabled " + target.method_5477().getString() + "'s flight."), true);
            target.method_64398(Messages.info("Your flight was " + (enable ? "enabled" : "disabled") + " by " + source.method_9214() + "."));
        }
        return 1;
    }

    private void registerDisposalCommand(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        LiteralArgumentBuilder disposal = (LiteralArgumentBuilder)class_2170.method_9247((String)"disposal").executes(ctx -> this.openDisposal((class_2168)ctx.getSource(), ((class_2168)ctx.getSource()).method_44023()));
        LiteralArgumentBuilder trash = (LiteralArgumentBuilder)class_2170.method_9247((String)"trash").executes(ctx -> this.openDisposal((class_2168)ctx.getSource(), ((class_2168)ctx.getSource()).method_44023()));
        LiteralArgumentBuilder trashcan = (LiteralArgumentBuilder)class_2170.method_9247((String)"trashcan").executes(ctx -> this.openDisposal((class_2168)ctx.getSource(), ((class_2168)ctx.getSource()).method_44023()));
        dispatcher.register(disposal);
        dispatcher.register(trash);
        dispatcher.register(trashcan);
    }

    private int openDisposal(class_2168 source, class_3222 target) {
        if (target == null) {
            source.method_9213(Messages.error("You must be a player to use this command."));
            return 0;
        }
        target.method_17355((class_3908)new class_747((syncId, playerInventory, player) -> class_1707.method_19245((int)syncId, (class_1661)playerInventory, (class_1263)new DisposalInventory()), (class_2561)class_2561.method_43470((String)"Disposal")));
        if (source.method_9228() == target) {
            source.method_9226(() -> Messages.info("Opened disposal."), false);
        }
        return 1;
    }
}

