/*
 * Decompiled with CFR 0.152.
 */
package f1nal.essentials.back;

import f1nal.essentials.config.BackConfig;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;

public final class BackManager {
    private static final Map<UUID, BackEntry> entries = new ConcurrentHashMap<UUID, BackEntry>();

    private BackManager() {
    }

    private static long windowMillis() {
        return (long)Math.max(1, BackConfig.get().windowSeconds) * 1000L;
    }

    public static void markBackPosition(class_3222 player) {
        long now = System.currentTimeMillis();
        BackEntry entry = new BackEntry((class_5321<class_1937>)player.method_51469().method_27983(), player.method_23317(), player.method_23318(), player.method_23321(), player.method_36454(), player.method_36455(), now + BackManager.windowMillis());
        entries.put(player.method_5667(), entry);
    }

    public static Optional<BackEntry> peek(class_3222 player) {
        BackManager.cleanup();
        BackEntry e = entries.get(player.method_5667());
        if (e == null) {
            return Optional.empty();
        }
        if (e.isExpired(System.currentTimeMillis())) {
            entries.remove(player.method_5667());
            return Optional.empty();
        }
        return Optional.of(e);
    }

    public static Optional<BackEntry> consume(class_3222 player) {
        BackManager.cleanup();
        UUID id = player.method_5667();
        BackEntry e = entries.get(id);
        if (e == null) {
            return Optional.empty();
        }
        if (e.isExpired(System.currentTimeMillis())) {
            entries.remove(id);
            return Optional.empty();
        }
        entries.remove(id);
        return Optional.of(e);
    }

    public static void cleanup() {
        long now = System.currentTimeMillis();
        entries.entrySet().removeIf(en -> ((BackEntry)en.getValue()).isExpired(now));
    }

    public static boolean teleportBack(class_3222 player) {
        Optional<BackEntry> opt = BackManager.consume(player);
        if (opt.isEmpty()) {
            return false;
        }
        BackEntry e = opt.get();
        MinecraftServer server = player.method_5682();
        if (server == null) {
            return false;
        }
        class_3218 world = server.method_3847(e.worldKey);
        if (world == null) {
            return false;
        }
        player.method_48105(world, e.x, e.y, e.z, Set.of(), e.yaw, e.pitch, false);
        return true;
    }

    public static final class BackEntry {
        public final class_5321<class_1937> worldKey;
        public final double x;
        public final double y;
        public final double z;
        public final float yaw;
        public final float pitch;
        public final long expiresAtMillis;

        public BackEntry(class_5321<class_1937> worldKey, double x, double y, double z, float yaw, float pitch, long expiresAtMillis) {
            this.worldKey = worldKey;
            this.x = x;
            this.y = y;
            this.z = z;
            this.yaw = yaw;
            this.pitch = pitch;
            this.expiresAtMillis = expiresAtMillis;
        }

        public boolean isExpired(long now) {
            return now >= this.expiresAtMillis;
        }
    }
}

