/*
 * Decompiled with CFR 0.152.
 */
package f1nal.essentials.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import f1nal.essentials.Messages;
import f1nal.essentials.back.BackManager;
import f1nal.essentials.config.CommandConfig;
import f1nal.essentials.config.TpaConfig;
import f1nal.essentials.tpa.TpaManager;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;

public final class TpaCommands {
    private TpaCommands() {
    }

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment, CommandConfig.CommandSettings settings) {
        LiteralArgumentBuilder tpa = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tpa").requires(settings.getPermissionRequirement())).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).executes(ctx -> TpaCommands.sendTpa((CommandContext<class_2168>)ctx, class_2186.method_9315((CommandContext)ctx, (String)"target"))));
        LiteralArgumentBuilder tpahere = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tpahere").requires(settings.getPermissionRequirement())).then(class_2170.method_9247((String)"all").executes(TpaCommands::sendTpahereAll))).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).executes(ctx -> TpaCommands.sendTpahere((CommandContext<class_2168>)ctx, class_2186.method_9315((CommandContext)ctx, (String)"target"))));
        LiteralArgumentBuilder tpaccept = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tpaccept").requires(settings.getPermissionRequirement())).executes(ctx -> TpaCommands.accept((CommandContext<class_2168>)ctx, null))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(ctx -> TpaCommands.accept((CommandContext<class_2168>)ctx, class_2186.method_9315((CommandContext)ctx, (String)"player"))));
        LiteralArgumentBuilder tpdeny = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tpdeny").requires(settings.getPermissionRequirement())).executes(ctx -> TpaCommands.deny((CommandContext<class_2168>)ctx, null))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(ctx -> TpaCommands.deny((CommandContext<class_2168>)ctx, class_2186.method_9315((CommandContext)ctx, (String)"player"))));
        LiteralArgumentBuilder tpcancel = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tpcancel").requires(settings.getPermissionRequirement())).executes(TpaCommands::cancel);
        dispatcher.register(tpa);
        dispatcher.register(tpahere);
        dispatcher.register(tpaccept);
        dispatcher.register(tpdeny);
        dispatcher.register(tpcancel);
    }

    private static int sendTpa(CommandContext<class_2168> ctx, class_3222 target) {
        class_2168 source = (class_2168)ctx.getSource();
        class_3222 sender = source.method_44023();
        if (sender == null) {
            source.method_9213(Messages.error("You must be a player to use this command."));
            return 0;
        }
        if (sender == target) {
            source.method_9213(Messages.error("You cannot send a TPA request to yourself."));
            return 0;
        }
        Optional<Long> cd = TpaManager.getSecondsLeftOnCancelCooldown(sender);
        if (cd.isPresent()) {
            source.method_9213(Messages.error("You must wait " + String.valueOf(cd.get()) + "s before sending another request."));
            return 0;
        }
        boolean created = TpaManager.createRequest(sender, target, TpaManager.Type.TPA);
        if (!created) {
            source.method_9213(Messages.error("You already have a pending request."));
            return 0;
        }
        source.method_9226(() -> Messages.info("TPA request sent to " + target.method_5477().getString() + "."), false);
        TpaCommands.sendButtonsToTarget(target, sender, false);
        return 1;
    }

    private static int sendTpahere(CommandContext<class_2168> ctx, class_3222 target) {
        class_2168 source = (class_2168)ctx.getSource();
        class_3222 sender = source.method_44023();
        if (sender == null) {
            source.method_9213(Messages.error("You must be a player to use this command."));
            return 0;
        }
        if (sender == target) {
            source.method_9213(Messages.error("You cannot send a TPAHere request to yourself."));
            return 0;
        }
        Optional<Long> cd = TpaManager.getSecondsLeftOnCancelCooldown(sender);
        if (cd.isPresent()) {
            source.method_9213(Messages.error("You must wait " + String.valueOf(cd.get()) + "s before sending another request."));
            return 0;
        }
        boolean created = TpaManager.createRequest(sender, target, TpaManager.Type.TPA_HERE);
        if (!created) {
            source.method_9213(Messages.error("You already have a pending request."));
            return 0;
        }
        source.method_9226(() -> Messages.info("TPAHere request sent to " + target.method_5477().getString() + "."), false);
        TpaCommands.sendButtonsToTarget(target, sender, true);
        return 1;
    }

    private static int sendTpahereAll(CommandContext<class_2168> ctx) {
        class_2168 source = (class_2168)ctx.getSource();
        class_3222 sender = source.method_44023();
        if (sender == null) {
            source.method_9213(Messages.error("You must be a player to use this command."));
            return 0;
        }
        Optional<Long> cd = TpaManager.getSecondsLeftOnCancelCooldown(sender);
        if (cd.isPresent()) {
            source.method_9213(Messages.error("You must wait " + String.valueOf(cd.get()) + "s before sending another request."));
            return 0;
        }
        MinecraftServer server = sender.method_5682();
        if (server == null) {
            return 0;
        }
        List players = server.method_3760().method_14571();
        int count = 0;
        for (class_3222 p : players) {
            if (p == sender || !TpaManager.createRequest(sender, p, TpaManager.Type.TPA_HERE)) continue;
            TpaCommands.sendButtonsToTarget(p, sender, true);
            ++count;
        }
        if (count == 0) {
            source.method_9213(Messages.error("Failed to create any requests (you may already have one pending)."));
            return 0;
        }
        int cnt = count;
        source.method_9226(() -> Messages.info("TPAHere request sent to " + cnt + " player(s)."), false);
        return 1;
    }

    private static int accept(CommandContext<class_2168> ctx, class_3222 from) {
        class_2168 source = (class_2168)ctx.getSource();
        class_3222 target = source.method_44023();
        if (target == null) {
            source.method_9213(Messages.error("You must be a player to use this command."));
            return 0;
        }
        Optional<TpaManager.Request> reqOpt = TpaManager.accept(target, from);
        if (reqOpt.isEmpty()) {
            source.method_9213(Messages.error("No pending request found."));
            return 0;
        }
        TpaManager.Request req = reqOpt.get();
        MinecraftServer server = target.method_5682();
        if (server == null) {
            return 0;
        }
        class_3222 sender = server.method_3760().method_14602(req.sender);
        if (sender == null) {
            source.method_9213(Messages.error("The requester is no longer online."));
            return 0;
        }
        if (req.type == TpaManager.Type.TPA) {
            BackManager.markBackPosition(sender);
            sender.method_48105(target.method_51469(), target.method_23317(), target.method_23318(), target.method_23321(), Set.of(), target.method_36454(), target.method_36455(), false);
        } else {
            BackManager.markBackPosition(target);
            target.method_48105(sender.method_51469(), sender.method_23317(), sender.method_23318(), sender.method_23321(), Set.of(), sender.method_36454(), sender.method_36455(), false);
        }
        sender.method_64398(Messages.success("Teleport request accepted by " + target.method_5477().getString() + "."));
        target.method_64398(Messages.success("Teleport request accepted."));
        return 1;
    }

    private static int deny(CommandContext<class_2168> ctx, class_3222 from) {
        class_3222 sender;
        class_2168 source = (class_2168)ctx.getSource();
        class_3222 target = source.method_44023();
        if (target == null) {
            source.method_9213(Messages.error("You must be a player to use this command."));
            return 0;
        }
        Optional<TpaManager.Request> reqOpt = TpaManager.deny(target, from);
        if (reqOpt.isEmpty()) {
            source.method_9213(Messages.error("No pending request found."));
            return 0;
        }
        TpaManager.Request req = reqOpt.get();
        MinecraftServer server = target.method_5682();
        if (server != null && (sender = server.method_3760().method_14602(req.sender)) != null) {
            sender.method_64398(Messages.warning(target.method_5477().getString() + " declined your teleport request."));
        }
        target.method_64398(Messages.info("Teleport request declined."));
        return 1;
    }

    private static int cancel(CommandContext<class_2168> ctx) {
        class_2168 source = (class_2168)ctx.getSource();
        class_3222 sender = source.method_44023();
        if (sender == null) {
            source.method_9213(Messages.error("You must be a player to use this command."));
            return 0;
        }
        boolean cancelled = TpaManager.cancel(sender);
        if (!cancelled) {
            source.method_9213(Messages.error("You have no pending request to cancel."));
            return 0;
        }
        int cd = TpaConfig.get().cooldownSeconds;
        source.method_9226(() -> Messages.info("Teleport request cancelled. You must wait " + cd + "s before sending another."), false);
        return 1;
    }

    private static void sendButtonsToTarget(class_3222 target, class_3222 sender, boolean here) {
        String senderName = sender.method_5477().getString();
        String typeText = here ? "wants you to teleport to them" : "wants to teleport to you";
        class_5250 header = class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)senderName).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)(" " + typeText + ". ")).method_27692(class_124.field_1080));
        class_5250 acceptBtn = class_2561.method_43470((String)"[Accept]").method_27692(class_124.field_1060).method_27694(s -> s.method_10982(Boolean.valueOf(true)).method_10958((class_2558)new class_2558.class_10609("/tpaccept " + senderName)).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)("Click to accept " + senderName + "'s request")).method_27692(class_124.field_1080)))).method_10852((class_2561)class_2561.method_43470((String)" "));
        class_5250 denyBtn = class_2561.method_43470((String)"[Decline]").method_27692(class_124.field_1061).method_27694(s -> s.method_10982(Boolean.valueOf(true)).method_10958((class_2558)new class_2558.class_10609("/tpdeny " + senderName)).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)("Click to decline " + senderName + "'s request")).method_27692(class_124.field_1080))));
        class_5250 hint = class_2561.method_43470((String)("Use /tpaccept " + senderName + " or /tpdeny " + senderName)).method_27692(class_124.field_1063);
        target.method_64398(Messages.custom((class_2561)header.method_10852((class_2561)class_2561.method_43470((String)"\n")).method_10852((class_2561)acceptBtn).method_10852((class_2561)denyBtn).method_10852((class_2561)class_2561.method_43470((String)"\n")).method_10852((class_2561)hint)));
    }
}

