/*
 * Decompiled with CFR 0.152.
 */
package f1nal.essentials.config;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;

public final class BackConfig {
    private static final int DEFAULT_WINDOW_SECONDS = 120;
    public final int windowSeconds;
    private static BackConfig INSTANCE;

    private BackConfig(int windowSeconds) {
        this.windowSeconds = windowSeconds;
    }

    public static synchronized BackConfig get() {
        if (INSTANCE == null) {
            INSTANCE = BackConfig.loadOrDefaults();
        }
        return INSTANCE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static BackConfig loadOrDefaults() {
        Path cfg = FabricLoader.getInstance().getConfigDir().resolve("essentials.yaml");
        if (!Files.exists(cfg, new LinkOption[0])) {
            return BackConfig.defaults();
        }
        try (BufferedReader reader = Files.newBufferedReader(cfg, StandardCharsets.UTF_8);){
            Yaml yaml = new Yaml(new LoaderOptions());
            Object root = yaml.load((Reader)reader);
            if (!(root instanceof Map)) {
                BackConfig backConfig = BackConfig.defaults();
                return backConfig;
            }
            Map map = (Map)root;
            Object backObj = map.get("back");
            if (!(backObj instanceof Map)) {
                BackConfig backConfig = BackConfig.defaults();
                return backConfig;
            }
            Map back = (Map)backObj;
            int window = BackConfig.coerceInt(back.get("window_seconds"), 120);
            if (window < 1) {
                window = 120;
            }
            BackConfig backConfig = new BackConfig(window);
            return backConfig;
        }
        catch (IOException e) {
            return BackConfig.defaults();
        }
    }

    private static BackConfig defaults() {
        return new BackConfig(120);
    }

    private static int coerceInt(Object value, int def) {
        if (value instanceof Number) {
            Number n = (Number)value;
            return n.intValue();
        }
        if (value instanceof String) {
            String s = (String)value;
            try {
                return Integer.parseInt(s.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return def;
    }
}

