/*
 * Decompiled with CFR 0.152.
 */
package com.mcserver.serverinfo;

import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class ServerInfo
extends JavaPlugin {
    private FileConfiguration config;

    @Override
    public void onEnable() {
        this.saveDefaultConfig();
        this.config = this.getConfig();
        this.getLogger().info("ServerInfo has been enabled!");
    }

    @Override
    public void onDisable() {
        this.getLogger().info("ServerInfo has been disabled!");
    }

    @Override
    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("serverinfo")) {
            if (!(sender instanceof Player) && !this.config.getBoolean("allow-console-usage")) {
                sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "This command can only be used by players.");
                return true;
            }
            if (args.length == 0) {
                this.displayServerInfo(sender);
                return true;
            }
            if (args.length == 1) {
                if (args[0].equalsIgnoreCase("help")) {
                    this.displayHelp(sender);
                    return true;
                }
                if (args[0].equalsIgnoreCase("rules")) {
                    this.displayRules(sender);
                    return true;
                }
                if (args[0].equalsIgnoreCase("commands")) {
                    this.displayCommands(sender);
                    return true;
                }
                if (args[0].equalsIgnoreCase("version")) {
                    this.displayVersion(sender);
                    return true;
                }
                if (args[0].equalsIgnoreCase("reload") && sender.hasPermission("serverinfo.reload")) {
                    this.reloadConfig();
                    this.config = this.getConfig();
                    sender.sendMessage(String.valueOf((Object)ChatColor.GREEN) + "ServerInfo configuration reloaded!");
                    return true;
                }
            }
            sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "Unknown command. Try /serverinfo help");
            return true;
        }
        return false;
    }

    private void displayServerInfo(CommandSender sender) {
        String headerFooter = ChatColor.translateAlternateColorCodes('&', this.config.getString("messages.header-footer"));
        String serverName = ChatColor.translateAlternateColorCodes('&', this.config.getString("server-info.name"));
        String serverVersion = ChatColor.translateAlternateColorCodes('&', this.config.getString("server-info.version"));
        String serverDescription = ChatColor.translateAlternateColorCodes('&', this.config.getString("server-info.description"));
        sender.sendMessage(headerFooter);
        sender.sendMessage(String.valueOf((Object)ChatColor.GOLD) + String.valueOf((Object)ChatColor.BOLD) + serverName);
        sender.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "Version: " + String.valueOf((Object)ChatColor.WHITE) + serverVersion);
        sender.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "Description: " + String.valueOf((Object)ChatColor.WHITE) + serverDescription);
        if (this.config.getBoolean("show-contact-info")) {
            String contactInfo = ChatColor.translateAlternateColorCodes('&', this.config.getString("server-info.contact"));
            sender.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "Contact: " + String.valueOf((Object)ChatColor.WHITE) + contactInfo);
        }
        sender.sendMessage(String.valueOf((Object)ChatColor.GREEN) + "Use /serverinfo help for available commands");
        sender.sendMessage(headerFooter);
    }

    private void displayHelp(CommandSender sender) {
        String headerFooter = ChatColor.translateAlternateColorCodes('&', this.config.getString("messages.header-footer"));
        sender.sendMessage(headerFooter);
        sender.sendMessage(String.valueOf((Object)ChatColor.GOLD) + String.valueOf((Object)ChatColor.BOLD) + "ServerInfo Help");
        sender.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "/serverinfo " + String.valueOf((Object)ChatColor.WHITE) + "- Display main server information");
        sender.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "/serverinfo help " + String.valueOf((Object)ChatColor.WHITE) + "- Display this help menu");
        sender.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "/serverinfo rules " + String.valueOf((Object)ChatColor.WHITE) + "- Display server rules");
        sender.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "/serverinfo commands " + String.valueOf((Object)ChatColor.WHITE) + "- Display important commands");
        sender.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "/serverinfo version " + String.valueOf((Object)ChatColor.WHITE) + "- Display server version info");
        if (sender.hasPermission("serverinfo.reload")) {
            sender.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "/serverinfo reload " + String.valueOf((Object)ChatColor.WHITE) + "- Reload configuration");
        }
        sender.sendMessage(headerFooter);
    }

    private void displayRules(CommandSender sender) {
        String headerFooter = ChatColor.translateAlternateColorCodes('&', this.config.getString("messages.header-footer"));
        List<String> rules = this.config.getStringList("rules");
        sender.sendMessage(headerFooter);
        sender.sendMessage(String.valueOf((Object)ChatColor.GOLD) + String.valueOf((Object)ChatColor.BOLD) + "Server Rules");
        int ruleNum = 1;
        for (String rule : rules) {
            sender.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + String.valueOf(ruleNum) + ". " + String.valueOf((Object)ChatColor.WHITE) + ChatColor.translateAlternateColorCodes('&', rule));
            ++ruleNum;
        }
        sender.sendMessage(headerFooter);
    }

    private void displayCommands(CommandSender sender) {
        String headerFooter = ChatColor.translateAlternateColorCodes('&', this.config.getString("messages.header-footer"));
        List<String> commands = this.config.getStringList("important-commands");
        sender.sendMessage(headerFooter);
        sender.sendMessage(String.valueOf((Object)ChatColor.GOLD) + String.valueOf((Object)ChatColor.BOLD) + "Important Commands");
        for (String cmd : commands) {
            sender.sendMessage(ChatColor.translateAlternateColorCodes('&', cmd));
        }
        sender.sendMessage(headerFooter);
    }

    private void displayVersion(CommandSender sender) {
        String headerFooter = ChatColor.translateAlternateColorCodes('&', this.config.getString("messages.header-footer"));
        String serverVersion = ChatColor.translateAlternateColorCodes('&', this.config.getString("server-info.version"));
        String minecraftVersion = ChatColor.translateAlternateColorCodes('&', this.config.getString("server-info.minecraft-version"));
        sender.sendMessage(headerFooter);
        sender.sendMessage(String.valueOf((Object)ChatColor.GOLD) + String.valueOf((Object)ChatColor.BOLD) + "Version Information");
        sender.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "Server Version: " + String.valueOf((Object)ChatColor.WHITE) + serverVersion);
        sender.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "Minecraft Version: " + String.valueOf((Object)ChatColor.WHITE) + minecraftVersion);
        if (this.config.getBoolean("show-supported-versions")) {
            String supportedVersions = ChatColor.translateAlternateColorCodes('&', this.config.getString("server-info.supported-versions"));
            sender.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "Supported Client Versions: " + String.valueOf((Object)ChatColor.WHITE) + supportedVersions);
        }
        sender.sendMessage(headerFooter);
    }
}

