/*
 * Decompiled with CFR 0.152.
 */
package com.boingboing;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class BounceConfig {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.DoubleValue BOUNCE_FACTOR;
    public static final ForgeConfigSpec.DoubleValue MIN_BOUNCE_VELOCITY;
    public static final ForgeConfigSpec.DoubleValue HORIZONTAL_CONSERVATION;
    public static final ForgeConfigSpec.DoubleValue IMPACT_THRESHOLD;
    public static final ForgeConfigSpec.DoubleValue SOUND_VOLUME;
    public static final ForgeConfigSpec.IntValue PARTICLE_COUNT;
    public static final ForgeConfigSpec.BooleanValue ENABLE_SOUND;
    public static final ForgeConfigSpec.BooleanValue ENABLE_PARTICLES;

    public static void register() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)SPEC, "boingboingitem.toml");
    }

    static {
        BUILDER.push("Bounce Physics");
        BOUNCE_FACTOR = BUILDER.comment("Vertical bounce factor (0.0 - 3.0)").comment("Higher value = higher bounce. Values > 1.0 = super bounce!").defineInRange("bounceFactor", 0.85, 0.0, 3.0);
        MIN_BOUNCE_VELOCITY = BUILDER.comment("Minimum velocity to trigger a bounce").comment("Below this value, the item stops").defineInRange("minBounceVelocity", 0.08, 0.01, 0.5);
        HORIZONTAL_CONSERVATION = BUILDER.comment("Horizontal velocity conservation (0.0 - 1.0)").comment("1.0 = no loss, 0.0 = full stop").defineInRange("horizontalConservation", 0.98, 0.0, 1.0);
        IMPACT_THRESHOLD = BUILDER.comment("Impact velocity threshold to trigger bounce").defineInRange("impactThreshold", 0.08, 0.01, 1.0);
        BUILDER.pop();
        BUILDER.push("Effects");
        ENABLE_SOUND = BUILDER.comment("Enable bounce sound").define("enableSound", true);
        SOUND_VOLUME = BUILDER.comment("Bounce sound volume (0.0 - 1.0)").defineInRange("soundVolume", 0.5, 0.0, 1.0);
        ENABLE_PARTICLES = BUILDER.comment("Enable bounce particles").define("enableParticles", true);
        PARTICLE_COUNT = BUILDER.comment("Number of particles per bounce").defineInRange("particleCount", 8, 1, 50);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

