/*
 * Decompiled with CFR 0.152.
 */
package com.boingboing;

import com.boingboing.BounceConfig;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ItemBounceHandler {
    private final Map<UUID, Vec3> previousVelocities = new ConcurrentHashMap<UUID, Vec3>();
    private final Map<UUID, Boolean> wasOnGround = new ConcurrentHashMap<UUID, Boolean>();

    @SubscribeEvent
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            this.previousVelocities.put(itemEntity.m_20148_(), Vec3.f_82478_);
            this.wasOnGround.put(itemEntity.m_20148_(), false);
        }
    }

    @SubscribeEvent
    public void onEntityLeaveLevel(EntityLeaveLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            this.previousVelocities.remove(itemEntity.m_20148_());
            this.wasOnGround.remove(itemEntity.m_20148_());
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.LevelTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (event.level.m_5776_()) {
            return;
        }
        Level level = event.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        serverLevel.m_142646_().m_142273_().forEach(entity -> {
            if (entity instanceof ItemEntity) {
                ItemEntity itemEntity = (ItemEntity)entity;
                this.handleBounce(itemEntity, serverLevel);
            }
        });
    }

    private void handleBounce(ItemEntity itemEntity, ServerLevel level) {
        UUID id = itemEntity.m_20148_();
        Vec3 currentVelocity = itemEntity.m_20184_();
        Vec3 prevVelocity = this.previousVelocities.getOrDefault(id, Vec3.f_82478_);
        boolean wasOnGroundBefore = this.wasOnGround.getOrDefault(id, false);
        double impactThreshold = (Double)BounceConfig.IMPACT_THRESHOLD.get();
        if (itemEntity.m_20096_() && !wasOnGroundBefore && prevVelocity.f_82480_ < -impactThreshold) {
            double impactSpeed = Math.abs(prevVelocity.f_82480_);
            double bounceFactor = (Double)BounceConfig.BOUNCE_FACTOR.get();
            double minBounceVelocity = (Double)BounceConfig.MIN_BOUNCE_VELOCITY.get();
            double horizontalConservation = (Double)BounceConfig.HORIZONTAL_CONSERVATION.get();
            double newYVelocity = impactSpeed * bounceFactor;
            if (newYVelocity > minBounceVelocity) {
                BlockPos blockBelow;
                BlockState blockState;
                double newX = prevVelocity.f_82479_ * horizontalConservation;
                double newZ = prevVelocity.f_82481_ * horizontalConservation;
                itemEntity.m_20334_(newX, newYVelocity, newZ);
                itemEntity.m_6853_(false);
                itemEntity.f_19812_ = true;
                if (((Boolean)BounceConfig.ENABLE_SOUND.get()).booleanValue()) {
                    float volume = (float)(Math.min(1.0, impactSpeed * 2.0) * (Double)BounceConfig.SOUND_VOLUME.get());
                    float pitch = 1.0f + (float)(Math.random() * 0.2 - 0.1);
                    level.m_6263_(null, itemEntity.m_20185_(), itemEntity.m_20186_(), itemEntity.m_20189_(), SoundEvents.f_12470_, SoundSource.NEUTRAL, volume, pitch);
                }
                if (((Boolean)BounceConfig.ENABLE_PARTICLES.get()).booleanValue() && !(blockState = level.m_8055_(blockBelow = BlockPos.m_274561_((double)itemEntity.m_20185_(), (double)(itemEntity.m_20186_() - 0.1), (double)itemEntity.m_20189_()))).m_60795_()) {
                    int particleCount = (Integer)BounceConfig.PARTICLE_COUNT.get();
                    level.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockState), itemEntity.m_20185_(), itemEntity.m_20186_() + 0.1, itemEntity.m_20189_(), particleCount, 0.15, 0.05, 0.15, 0.05);
                }
            }
        }
        this.previousVelocities.put(id, currentVelocity);
        this.wasOnGround.put(id, itemEntity.m_20096_());
    }
}

