/*
 * Decompiled with CFR 0.152.
 */
package com.boingboing;

import com.boingboing.BounceConfig;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.EntityLeaveLevelEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

public class ItemBounceHandler {
    private final Map<UUID, Vec3> previousVelocities = new ConcurrentHashMap<UUID, Vec3>();
    private final Map<UUID, Boolean> wasOnGround = new ConcurrentHashMap<UUID, Boolean>();

    @SubscribeEvent
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            this.previousVelocities.put(itemEntity.getUUID(), Vec3.ZERO);
            this.wasOnGround.put(itemEntity.getUUID(), false);
        }
    }

    @SubscribeEvent
    public void onEntityLeaveLevel(EntityLeaveLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            this.previousVelocities.remove(itemEntity.getUUID());
            this.wasOnGround.remove(itemEntity.getUUID());
        }
    }

    @SubscribeEvent
    public void onLevelTick(LevelTickEvent.Pre event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        serverLevel.getEntities().getAll().forEach(entity -> {
            if (entity instanceof ItemEntity) {
                ItemEntity itemEntity = (ItemEntity)entity;
                this.handleBounce(itemEntity, serverLevel);
            }
        });
    }

    private void handleBounce(ItemEntity itemEntity, ServerLevel level) {
        UUID id = itemEntity.getUUID();
        Vec3 currentVelocity = itemEntity.getDeltaMovement();
        Vec3 prevVelocity = this.previousVelocities.getOrDefault(id, Vec3.ZERO);
        boolean wasOnGroundBefore = this.wasOnGround.getOrDefault(id, false);
        double impactThreshold = (Double)BounceConfig.IMPACT_THRESHOLD.get();
        if (itemEntity.onGround() && !wasOnGroundBefore && prevVelocity.y < -impactThreshold) {
            double impactSpeed = Math.abs(prevVelocity.y);
            double bounceFactor = (Double)BounceConfig.BOUNCE_FACTOR.get();
            double minBounceVelocity = (Double)BounceConfig.MIN_BOUNCE_VELOCITY.get();
            double horizontalConservation = (Double)BounceConfig.HORIZONTAL_CONSERVATION.get();
            double newYVelocity = impactSpeed * bounceFactor;
            if (newYVelocity > minBounceVelocity) {
                BlockPos blockBelow;
                BlockState blockState;
                double newX = prevVelocity.x * horizontalConservation;
                double newZ = prevVelocity.z * horizontalConservation;
                itemEntity.setDeltaMovement(newX, newYVelocity, newZ);
                itemEntity.setOnGround(false);
                itemEntity.hasImpulse = true;
                if (((Boolean)BounceConfig.ENABLE_SOUND.get()).booleanValue()) {
                    float volume = (float)(Math.min(1.0, impactSpeed * 2.0) * (Double)BounceConfig.SOUND_VOLUME.get());
                    float pitch = 1.0f + (float)(Math.random() * 0.2 - 0.1);
                    level.playSound(null, itemEntity.getX(), itemEntity.getY(), itemEntity.getZ(), SoundEvents.SLIME_SQUISH_SMALL, SoundSource.NEUTRAL, volume, pitch);
                }
                if (((Boolean)BounceConfig.ENABLE_PARTICLES.get()).booleanValue() && !(blockState = level.getBlockState(blockBelow = BlockPos.containing((double)itemEntity.getX(), (double)(itemEntity.getY() - 0.1), (double)itemEntity.getZ()))).isAir()) {
                    int particleCount = (Integer)BounceConfig.PARTICLE_COUNT.get();
                    level.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, blockState), itemEntity.getX(), itemEntity.getY() + 0.1, itemEntity.getZ(), particleCount, 0.15, 0.05, 0.15, 0.05);
                }
            }
        }
        this.previousVelocities.put(id, currentVelocity);
        this.wasOnGround.put(id, itemEntity.onGround());
    }
}

