/*
 * Decompiled with CFR 0.152.
 */
package com.boingboing;

import com.boingboing.BounceConfigFabric;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1542;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class ItemBounceHandler {
    private final Map<UUID, class_243> previousVelocities = new ConcurrentHashMap<UUID, class_243>();
    private final Map<UUID, Boolean> wasOnGround = new ConcurrentHashMap<UUID, Boolean>();

    public void onWorldTick(class_1937 world) {
        if (world.method_8608()) {
            return;
        }
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        serverWorld.method_27909().forEach(entity -> {
            if (entity instanceof class_1542) {
                class_1542 itemEntity = (class_1542)entity;
                this.handleBounce(itemEntity, serverWorld);
            }
        });
    }

    private void handleBounce(class_1542 itemEntity, class_3218 world) {
        UUID id = itemEntity.method_5667();
        class_243 currentVelocity = itemEntity.method_18798();
        class_243 prevVelocity = this.previousVelocities.getOrDefault(id, class_243.field_1353);
        boolean wasOnGroundBefore = this.wasOnGround.getOrDefault(id, false);
        double impactThreshold = BounceConfigFabric.impactThreshold;
        if (itemEntity.method_24828() && !wasOnGroundBefore && prevVelocity.field_1351 < -impactThreshold) {
            double impactSpeed = Math.abs(prevVelocity.field_1351);
            double bounceFactor = BounceConfigFabric.bounceFactor;
            double minBounceVelocity = BounceConfigFabric.minBounceVelocity;
            double horizontalConservation = BounceConfigFabric.horizontalConservation;
            double newYVelocity = impactSpeed * bounceFactor;
            if (newYVelocity > minBounceVelocity) {
                class_2338 blockBelow;
                class_2680 blockState;
                double newX = prevVelocity.field_1352 * horizontalConservation;
                double newZ = prevVelocity.field_1350 * horizontalConservation;
                itemEntity.method_18800(newX, newYVelocity, newZ);
                itemEntity.method_24830(false);
                itemEntity.field_6037 = true;
                if (BounceConfigFabric.enableSound) {
                    float volume = (float)(Math.min(1.0, impactSpeed * 2.0) * BounceConfigFabric.soundVolume);
                    float pitch = 1.0f + (float)(Math.random() * 0.2 - 0.1);
                    world.method_43128(null, itemEntity.method_23317(), itemEntity.method_23318(), itemEntity.method_23321(), class_3417.field_15148, class_3419.field_15254, volume, pitch);
                }
                if (BounceConfigFabric.enableParticles && !(blockState = world.method_8320(blockBelow = class_2338.method_49637((double)itemEntity.method_23317(), (double)(itemEntity.method_23318() - 0.1), (double)itemEntity.method_23321()))).method_26215()) {
                    int particleCount = BounceConfigFabric.particleCount;
                    world.method_14199((class_2394)new class_2388(class_2398.field_11217, blockState), itemEntity.method_23317(), itemEntity.method_23318() + 0.1, itemEntity.method_23321(), particleCount, 0.15, 0.05, 0.15, 0.05);
                }
            }
        }
        this.previousVelocities.put(id, currentVelocity);
        this.wasOnGround.put(id, itemEntity.method_24828());
    }
}

