/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import me.testaccount666.migration.LegacyDataMigrator;
import me.testaccount666.serversystem.clickablesigns.SignManager;
import me.testaccount666.serversystem.commands.executables.kit.manager.KitManager;
import me.testaccount666.serversystem.commands.executables.warp.manager.WarpManager;
import me.testaccount666.serversystem.commands.management.CommandManager;
import me.testaccount666.serversystem.listener.management.ListenerManager;
import me.testaccount666.serversystem.managers.config.ConfigReader;
import me.testaccount666.serversystem.managers.config.ConfigurationManager;
import me.testaccount666.serversystem.managers.database.economy.AbstractEconomyDatabaseManager;
import me.testaccount666.serversystem.managers.database.economy.MySqlEconomyDatabaseManager;
import me.testaccount666.serversystem.managers.database.economy.SqliteEconomyDatabaseManager;
import me.testaccount666.serversystem.managers.database.moderation.AbstractModerationDatabaseManager;
import me.testaccount666.serversystem.managers.database.moderation.MySqlModerationDatabaseManager;
import me.testaccount666.serversystem.managers.database.moderation.SqliteModerationDatabaseManager;
import me.testaccount666.serversystem.placeholderapi.PlaceholderApiSupport;
import me.testaccount666.serversystem.placeholderapi.PlaceholderManager;
import me.testaccount666.serversystem.updates.AbstractUpdateChecker;
import me.testaccount666.serversystem.updates.UpdateCheckerType;
import me.testaccount666.serversystem.userdata.CachedUser;
import me.testaccount666.serversystem.userdata.OfflineUser;
import me.testaccount666.serversystem.userdata.UserManager;
import me.testaccount666.serversystem.userdata.money.EconomyProvider;
import me.testaccount666.serversystem.userdata.money.vault.EconomyVaultAPI;
import me.testaccount666.serversystem.utils.Version;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Nullable;

public final class ServerSystem
extends JavaPlugin {
    public static final Version CURRENT_VERSION = new Version("3.1.0");
    public static ServerSystem Instance;
    private static Logger _Log;
    private UserManager _userManager;
    private CommandManager _commandManager;
    private ListenerManager _listenerManager;
    private PlaceholderManager _placeholderManager;
    private EconomyProvider _economyProvider;
    private ConfigurationManager _configManager;
    private AbstractEconomyDatabaseManager _economyDatabaseManager;
    private WarpManager _warpManager;
    private AbstractModerationDatabaseManager _moderationDatabaseManager;
    @Nullable
    private KitManager _kitManager;
    private SignManager _signManager;
    private AbstractUpdateChecker _updateChecker;

    public static Version getServerVersion() {
        String version = Bukkit.getVersion();
        version = version.substring(version.indexOf("MC: ") + 4, version.indexOf(")"));
        ServerSystem.getLog().log(Level.FINE, "Server version: " + version);
        return new Version(version);
    }

    public void onEnable() {
        Instance = this;
        _Log = this.getLogger();
        LegacyDataMigrator migrator = new LegacyDataMigrator();
        if (migrator.isLegacyDataPresent()) {
            ServerSystem.getLog().log(Level.INFO, "Legacy data detected. Attempting to migrate...");
            migrator.prepareMigration();
        }
        File previousVersionFile = new File(this.getDataFolder(), "previousVersion.yml");
        YamlConfiguration previousVersionConfig = YamlConfiguration.loadConfiguration((File)previousVersionFile);
        previousVersionConfig.set("previousVersion", (Object)CURRENT_VERSION.toString());
        try {
            previousVersionConfig.save(previousVersionFile);
        }
        catch (IOException exception) {
            throw new RuntimeException("Error updating 'previousVersion'", exception);
        }
        try {
            this.initialize();
        }
        catch (Exception exception) {
            ServerSystem.getLog().log(Level.SEVERE, "Failed to initialize the plugin", exception);
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.startUpdateChecker();
        Bukkit.getScheduler().runTaskLater((Plugin)this, migrator::migrateLegacyData, 1L);
        Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
            this._commandManager.registerCommands();
            this._listenerManager.registerListeners();
            this._placeholderManager.registerPlaceholders();
        }, 2L);
    }

    private void initialize() throws Exception {
        this._configManager = new ConfigurationManager((Plugin)this);
        this._configManager.loadAllConfigs();
        String moderationType = this._configManager.getModerationConfig().getString("Moderation.StorageType.Value");
        this._moderationDatabaseManager = switch (moderationType.toLowerCase()) {
            case "sqlite" -> new SqliteModerationDatabaseManager(this.getDataFolder());
            case "mysql" -> new MySqlModerationDatabaseManager(this._configManager.getModerationConfig());
            default -> throw new IllegalStateException("Unsupported moderation storage: " + moderationType + " - Supported values: sqlite, mysql");
        };
        if (EconomyVaultAPI.isVaultInstalled()) {
            EconomyVaultAPI.initialize();
        }
        PlaceholderApiSupport.registerPlaceholders();
        this._moderationDatabaseManager.initialize();
        String economyStorageType = this._configManager.getEconomyConfig().getString("Economy.StorageType.Value");
        this._economyDatabaseManager = switch (economyStorageType.toLowerCase()) {
            case "sqlite" -> new SqliteEconomyDatabaseManager(this.getDataFolder());
            case "mysql" -> new MySqlEconomyDatabaseManager(this._configManager.getEconomyConfig());
            default -> throw new IllegalStateException("Unsupported economy storage: " + economyStorageType + " - Supported values: sqlite, mysql");
        };
        this._commandManager = new CommandManager(this._configManager.getCommandsConfig());
        this._listenerManager = new ListenerManager(this._commandManager);
        this._placeholderManager = new PlaceholderManager();
        this._economyProvider = new EconomyProvider(this._configManager.getEconomyConfig());
        this._userManager = new UserManager();
        this._kitManager = new KitManager();
        Bukkit.getScheduler().runTask((Plugin)this, () -> {
            File warpFile = Path.of(this.getDataFolder().getPath(), "data", "warps.yml").toFile();
            YamlConfiguration warpConfig = YamlConfiguration.loadConfiguration((File)warpFile);
            this._warpManager = new WarpManager((FileConfiguration)warpConfig, warpFile);
            this._signManager = new SignManager();
            this._signManager.loadSignTypes();
        });
    }

    public void onDisable() {
        if (this._userManager != null) {
            this.saveAllUsers();
        }
        if (this._commandManager != null) {
            this._commandManager.unregisterCommands();
        }
        if (this._listenerManager != null) {
            this._listenerManager.unregisterListeners();
        }
        PlaceholderApiSupport.unregisterPlaceholders();
        if (this._economyDatabaseManager != null) {
            this._economyDatabaseManager.shutdown();
        }
        if (this._moderationDatabaseManager != null) {
            this._moderationDatabaseManager.shutdown();
        }
    }

    private void saveAllUsers() {
        this._userManager.getCachedUsers().stream().map(CachedUser::getOfflineUser).forEach(OfflineUser::save);
    }

    private void startUpdateChecker() {
        ConfigReader generalConfig = this._configManager.getGeneralConfig();
        Optional<UpdateCheckerType> updateCheckerType = this.resolveUpdateCheckerType(generalConfig);
        if (updateCheckerType.isEmpty()) {
            this.handleInvalidUpdateCheckerType(generalConfig);
            return;
        }
        this.initializeUpdateChecker(updateCheckerType.get(), generalConfig);
        this.scheduleUpdateChecks(generalConfig);
    }

    private Optional<UpdateCheckerType> resolveUpdateCheckerType(ConfigReader generalConfig) {
        String typeString = generalConfig.getString("UpdateChecker.Type.Value");
        if (typeString == null || typeString.isBlank()) {
            typeString = "DISABLED";
        }
        return UpdateCheckerType.of(typeString);
    }

    private void handleInvalidUpdateCheckerType(ConfigReader generalConfig) {
        String typeString = generalConfig.getString("UpdateChecker.Type.Value");
        String availableTypes = this.formatAvailableUpdateCheckerTypes();
        ServerSystem.getLog().warning("Updater type '" + typeString + "' not found. Available options: " + availableTypes);
        this._updateChecker = UpdateCheckerType.DISABLED.getFactory().get();
    }

    private String formatAvailableUpdateCheckerTypes() {
        return Arrays.stream(UpdateCheckerType.values()).map(Enum::name).collect(Collectors.joining(", "));
    }

    private void initializeUpdateChecker(UpdateCheckerType type, ConfigReader generalConfig) {
        boolean autoUpdate = this.determineAutoUpdateSetting(generalConfig);
        this._updateChecker = type.getFactory().get();
        this._updateChecker.setAutoUpdate(autoUpdate);
    }

    private boolean determineAutoUpdateSetting(ConfigReader generalConfig) {
        boolean autoUpdate = generalConfig.getBoolean("UpdateChecker.AutoUpdate");
        if (Boolean.parseBoolean(System.getProperty("serversystem.disable-auto-download", "false"))) {
            autoUpdate = false;
        }
        return autoUpdate;
    }

    private void scheduleUpdateChecks(ConfigReader generalConfig) {
        boolean checkForUpdates = generalConfig.getBoolean("UpdateChecker.CheckForUpdates");
        if (!checkForUpdates) {
            return;
        }
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, this::performUpdateCheck, 20L, 72000L);
    }

    private void performUpdateCheck() {
        ((CompletableFuture)this._updateChecker.hasUpdate().exceptionally(this::handleUpdateCheckError)).thenAccept(this::handleUpdateCheckResult);
    }

    private Boolean handleUpdateCheckError(Throwable throwable) {
        ServerSystem.getLog().log(Level.WARNING, "Error checking for updates", throwable);
        return false;
    }

    private void handleUpdateCheckResult(boolean hasUpdate) {
        if (!hasUpdate) {
            return;
        }
        ((CompletableFuture)this._updateChecker.downloadUpdate().exceptionally(this::handleUpdateDownloadError)).thenAccept(this::handleUpdateDownloadResult);
    }

    private Boolean handleUpdateDownloadError(Throwable throwable) {
        ServerSystem.getLog().log(Level.WARNING, "Error downloading update", throwable);
        return false;
    }

    private void handleUpdateDownloadResult(boolean success) {
        if (success) {
            return;
        }
        ServerSystem.getLog().warning("Update-Download failed!");
    }

    public static Logger getLog() {
        return _Log;
    }

    public UserManager getUserManager() {
        return this._userManager;
    }

    public CommandManager getCommandManager() {
        return this._commandManager;
    }

    public ListenerManager getListenerManager() {
        return this._listenerManager;
    }

    public PlaceholderManager getPlaceholderManager() {
        return this._placeholderManager;
    }

    public EconomyProvider getEconomyProvider() {
        return this._economyProvider;
    }

    public ConfigurationManager getConfigManager() {
        return this._configManager;
    }

    public AbstractEconomyDatabaseManager getEconomyDatabaseManager() {
        return this._economyDatabaseManager;
    }

    public WarpManager getWarpManager() {
        return this._warpManager;
    }

    public AbstractModerationDatabaseManager getModerationDatabaseManager() {
        return this._moderationDatabaseManager;
    }

    @Nullable
    public KitManager getKitManager() {
        return this._kitManager;
    }

    public SignManager getSignManager() {
        return this._signManager;
    }

    public AbstractUpdateChecker getUpdateChecker() {
        return this._updateChecker;
    }
}

