/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.clickablesigns.executables.give;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.logging.Level;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.clickablesigns.AbstractSignConfigurator;
import me.testaccount666.serversystem.clickablesigns.SignType;
import me.testaccount666.serversystem.clickablesigns.cost.CostType;
import me.testaccount666.serversystem.clickablesigns.util.SignUtils;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.utils.BiDirectionalHashMap;
import me.testaccount666.serversystem.utils.ComponentColor;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.block.sign.SignSide;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class ConfiguratorGiveSign
extends AbstractSignConfigurator
implements Listener {
    private static final BiDirectionalHashMap<User, Sign> _CONFIGURATORS = new BiDirectionalHashMap();

    @Override
    protected String getCreatePermissionNode() {
        return "ClickableSigns.Give.Create";
    }

    @Override
    protected SignType getSignType() {
        return SignType.GIVE;
    }

    @Override
    protected boolean validateConfiguration(User user, Sign sign, YamlConfiguration config) {
        return true;
    }

    @Override
    protected void addSignSpecificConfiguration(User user, Sign sign, FileConfiguration config) {
    }

    @Override
    protected String getSuccessMessageKey() {
        return "Give.Created";
    }

    @Override
    public void execute(User user, Sign sign) {
        if (!this.validatePermission(user)) {
            return;
        }
        _CONFIGURATORS.put(user, sign);
        MessageBuilder.sign("Give.Configuring", user).build();
    }

    @EventHandler
    public void onSignRightClick(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block clickedBlock = event.getClickedBlock();
        if (clickedBlock == null) {
            return;
        }
        BlockState blockState = clickedBlock.getState();
        if (!(blockState instanceof Sign)) {
            return;
        }
        Sign sign = (Sign)blockState;
        Optional<User> userOptional = _CONFIGURATORS.getKey(sign);
        if (userOptional.isEmpty()) {
            return;
        }
        User user = userOptional.get();
        if (!user.getUuid().equals(event.getPlayer().getUniqueId())) {
            return;
        }
        event.setCancelled(true);
        ItemStack itemToGive = event.getPlayer().getInventory().getItemInMainHand();
        if (itemToGive.isEmpty()) {
            MessageBuilder.sign("Give.NoItem", user).build();
            return;
        }
        File signFile = SignUtils.getSignFile(sign.getLocation());
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)signFile);
        config.set("Key", (Object)this.getSignType().name());
        config.set("Cost.Type", (Object)CostType.NONE.name());
        config.set("Cost.Amount", (Object)0);
        config.set("Item", (Object)itemToGive);
        try {
            config.save(signFile);
        }
        catch (IOException exception) {
            user.sendMessage(exception.getMessage());
            ServerSystem.getLog().log(Level.SEVERE, "Failed to save sign configuration " + signFile.getAbsolutePath(), exception);
            return;
        }
        ServerSystem.Instance.getSignManager().addSignType(sign.getLocation(), this.getSignType());
        _CONFIGURATORS.removeByValue(sign);
        SignSide front = sign.getSide(Side.FRONT);
        front.line(0, ComponentColor.translateToComponent(SignType.GIVE.signName()));
        front.line(1, ComponentColor.translateToComponent("&2" + itemToGive.getType().name()));
        SignSide back = sign.getSide(Side.BACK);
        for (int index = 0; index < 4; ++index) {
            back.line(index, front.line(index));
        }
        sign.update();
    }

    private boolean validatePermission(User user) {
        if (!PermissionManager.hasPermission(user, this.getCreatePermissionNode(), false)) {
            MessageBuilder.general("NoPermission", user).postModifier(message -> message.replace("<PERMISSION>", PermissionManager.getPermission(this.getCreatePermissionNode()))).build();
            return false;
        }
        return true;
    }
}

