/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.clickablesigns.executables.kit;

import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.clickablesigns.AbstractSignConfigurator;
import me.testaccount666.serversystem.clickablesigns.SignType;
import me.testaccount666.serversystem.commands.executables.kit.manager.KitManager;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.utils.ChatColor;
import me.testaccount666.serversystem.utils.ComponentColor;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.block.sign.SignSide;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfiguratorKitSign
extends AbstractSignConfigurator {
    @Override
    protected String getCreatePermissionNode() {
        return "ClickableSigns.Kit.Create";
    }

    @Override
    protected SignType getSignType() {
        return SignType.KIT;
    }

    @Override
    protected boolean validateConfiguration(User user, Sign sign, YamlConfiguration config) {
        KitManager kitManager = ServerSystem.Instance.getKitManager();
        if (kitManager == null) {
            MessageBuilder.sign("Kit.NoKitManager", user).build();
            return false;
        }
        SignSide front = sign.getSide(Side.FRONT);
        String kitName = ComponentColor.componentToString(front.line(1));
        if (kitName.isEmpty()) {
            MessageBuilder.sign("Kit.NoKitSpecified", user).build();
            return false;
        }
        if (!kitManager.kitExists(kitName.toLowerCase())) {
            MessageBuilder.sign("Kit.KitNotFound", user).postModifier(message -> message.replace("<KIT>", kitName)).build();
            return false;
        }
        front.line(0, ComponentColor.translateToComponent(SignType.KIT.signName()));
        front.line(1, ComponentColor.translateToComponent("&2" + kitName));
        SignSide back = sign.getSide(Side.BACK);
        for (int index = 0; index < 4; ++index) {
            back.line(index, front.line(index));
        }
        sign.update();
        return true;
    }

    @Override
    protected void addSignSpecificConfiguration(User user, Sign sign, FileConfiguration config) {
        String kitName = sign.getSide(Side.FRONT).getLine(1);
        kitName = ChatColor.stripColor(kitName);
        config.set("KitName", (Object)kitName);
    }

    @Override
    protected String getSuccessMessageKey() {
        return "Kit.Created";
    }
}

