/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.clearinventory;

import java.util.Optional;
import me.testaccount666.serversystem.commands.ServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.AbstractServerSystemCommand;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

@ServerSystemCommand(name="clearinventory")
public class CommandClearInventory
extends AbstractServerSystemCommand {
    @Override
    public void execute(User commandSender, Command command, String label, String ... arguments) {
        boolean isSelf;
        if (!this.checkBasePermission(commandSender, "ClearInventory.Use")) {
            return;
        }
        if (this.handleConsoleWithNoTarget(commandSender, this.getSyntaxPath(command), label, arguments)) {
            return;
        }
        Optional<User> targetUserOptional = this.getTargetUser(commandSender, arguments);
        if (targetUserOptional.isEmpty()) {
            MessageBuilder.general("PlayerNotFound", commandSender).target(arguments[0]).build();
            return;
        }
        User targetUser = targetUserOptional.get();
        Player targetPlayer = targetUser.getPlayer();
        boolean bl = isSelf = targetUser == commandSender;
        if (!isSelf && !this.checkOtherPermission(commandSender, "ClearInventory.Other", targetPlayer.getName())) {
            return;
        }
        PlayerInventory inventory = targetPlayer.getInventory();
        inventory.clear();
        inventory.setContents(new ItemStack[0]);
        inventory.setArmorContents(new ItemStack[0]);
        inventory.setExtraContents(new ItemStack[0]);
        inventory.setStorageContents(new ItemStack[0]);
        String messagePath = isSelf ? "ClearInventory.Success" : "ClearInventory.SuccessOther";
        MessageBuilder.command(messagePath, commandSender).target(targetPlayer.getName()).build();
        if (isSelf) {
            return;
        }
        MessageBuilder.command("ClearInventory.Success", targetUser).sender(commandSender.getName().get()).target(targetPlayer.getName()).build();
    }

    @Override
    public String getSyntaxPath(Command command) {
        return "ClearInventory";
    }

    @Override
    public boolean hasCommandAccess(Player player, Command command) {
        return PermissionManager.hasCommandPermission((CommandSender)player, "ClearInventory.Use", false);
    }
}

