/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.enderchest;

import java.util.Optional;
import me.testaccount666.serversystem.commands.ServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.AbstractServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.enderchest.offline.CommandOfflineEnderChest;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.userdata.ConsoleUser;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@ServerSystemCommand(name="enderchest", variants={"offlineenderchest"})
public class CommandEnderChest
extends AbstractServerSystemCommand {
    public final CommandOfflineEnderChest offlineEnderChest = new CommandOfflineEnderChest();

    @Override
    public void execute(User commandSender, Command command, String label, String ... arguments) {
        if (command.getName().toLowerCase().startsWith("offline")) {
            this.offlineEnderChest.execute(commandSender, command, label, arguments);
            return;
        }
        this.executeEnderChestCommand(commandSender, arguments);
    }

    public void executeEnderChestCommand(User commandSender, String ... arguments) {
        boolean isSelf;
        if (!this.checkBasePermission(commandSender, "EnderChest.Use")) {
            return;
        }
        if (commandSender instanceof ConsoleUser) {
            MessageBuilder.general("NotPlayer", commandSender).build();
            return;
        }
        Optional<User> targetUserOptional = this.getTargetUser(commandSender, arguments);
        if (targetUserOptional.isEmpty()) {
            MessageBuilder.general("PlayerNotFound", commandSender).target(arguments[0]).build();
            return;
        }
        User targetUser = targetUserOptional.get();
        Player targetPlayer = targetUser.getPlayer();
        boolean bl = isSelf = targetUser == commandSender;
        if (!isSelf && !this.checkOtherPermission(commandSender, "EnderChest.Other", targetPlayer.getName())) {
            return;
        }
        commandSender.getPlayer().openInventory(targetPlayer.getEnderChest());
    }

    @Override
    public String getSyntaxPath(Command command) {
        if (command.getName().toLowerCase().startsWith("offline")) {
            return this.offlineEnderChest.getSyntaxPath(command);
        }
        return "EnderChest";
    }

    @Override
    public boolean hasCommandAccess(Player player, Command command) {
        return PermissionManager.hasCommandPermission((CommandSender)player, "EnderChest.Use", false);
    }
}

