/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.gamemode;

import java.util.Arrays;
import java.util.Optional;
import me.testaccount666.serversystem.commands.ServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.AbstractServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.gamemode.TabCompleterGameMode;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.managers.messages.MappingsData;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.GameMode;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@ServerSystemCommand(name="gamemode", variants={"gms", "gmc", "gma", "gmsp"}, tabCompleter=TabCompleterGameMode.class)
public class CommandGameMode
extends AbstractServerSystemCommand {
    @Override
    public void execute(User commandSender, Command command, String label, String ... arguments) {
        String[] stringArray;
        if (command.getName().equalsIgnoreCase("gms")) {
            this.handleGameModeCommand(commandSender, command, label, GameMode.SURVIVAL, arguments);
            return;
        }
        if (command.getName().equalsIgnoreCase("gmc")) {
            this.handleGameModeCommand(commandSender, command, label, GameMode.CREATIVE, arguments);
            return;
        }
        if (command.getName().equalsIgnoreCase("gma")) {
            this.handleGameModeCommand(commandSender, command, label, GameMode.ADVENTURE, arguments);
            return;
        }
        if (command.getName().equalsIgnoreCase("gmsp")) {
            this.handleGameModeCommand(commandSender, command, label, GameMode.SPECTATOR, arguments);
            return;
        }
        if (arguments.length < 1) {
            MessageBuilder.general("InvalidArguments", commandSender).syntaxPath(this.getSyntaxPath(command)).label(label).build();
            return;
        }
        Optional<GameMode> gameModeOptional = this.parseGameMode(arguments[0]);
        if (gameModeOptional.isEmpty()) {
            MessageBuilder.command("GameMode.InvalidGameMode", commandSender).postModifier(message -> this.replaceGameModePlaceholder((String)message, arguments[0])).build();
            return;
        }
        if (arguments.length > 1) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = arguments[1];
        } else {
            stringArray = new String[]{};
        }
        String[] newArguments = stringArray;
        this.handleGameModeCommand(commandSender, command, label, gameModeOptional.get(), newArguments);
    }

    public void handleGameModeCommand(User commandSender, Command command, String label, GameMode gameMode, String[] arguments) {
        String gameModePermission;
        if (!this.checkBasePermission(commandSender, "GameMode.Use")) {
            return;
        }
        switch (gameMode) {
            default: {
                throw new MatchException(null, null);
            }
            case SURVIVAL: {
                String string = "GameMode.Survival";
                break;
            }
            case CREATIVE: {
                String string = "GameMode.Creative";
                break;
            }
            case ADVENTURE: {
                String string = "GameMode.Adventure";
                break;
            }
            case SPECTATOR: {
                String string = gameModePermission = "GameMode.Spectator";
            }
        }
        if (!this.checkBasePermission(commandSender, gameModePermission)) {
            return;
        }
        if (this.handleConsoleWithNoTarget(commandSender, this.getSyntaxPath(command), label, arguments)) {
            return;
        }
        Optional<User> targetUserOptional = this.getTargetUser(commandSender, arguments);
        if (targetUserOptional.isEmpty()) {
            MessageBuilder.general("PlayerNotFound", commandSender).target(arguments[0]).build();
            return;
        }
        User targetUser = targetUserOptional.get();
        Player targetPlayer = targetUser.getPlayer();
        boolean isSelf = targetPlayer == commandSender.getPlayer();
        targetPlayer.setGameMode(gameMode);
        String gameModeNameSender = MappingsData.gameMode(commandSender).getGameModeName(gameMode).orElse(gameMode.name());
        String messageKey = isSelf ? "GameMode.Success" : "GameMode.SuccessOther";
        MessageBuilder.command(messageKey, commandSender).target(targetPlayer.getName()).postModifier(message -> this.replaceGameModePlaceholder((String)message, gameModeNameSender)).build();
        if (isSelf) {
            return;
        }
        String gameModeNameTarget = MappingsData.gameMode(targetUser).getGameModeName(gameMode).orElse(gameMode.name());
        MessageBuilder.command("GameMode.Success", targetUser).sender(commandSender.getName().get()).target(targetPlayer.getName()).postModifier(message -> this.replaceGameModePlaceholder((String)message, gameModeNameTarget)).build();
    }

    private String replaceGameModePlaceholder(String message, String gameModeName) {
        return message.replace("<GAMEMODE>", gameModeName);
    }

    private Optional<GameMode> parseGameMode(String input) {
        try {
            int value = Integer.parseInt(input);
            return switch (value) {
                case 0 -> Optional.of(GameMode.SURVIVAL);
                case 1 -> Optional.of(GameMode.CREATIVE);
                case 2 -> Optional.of(GameMode.ADVENTURE);
                case 3 -> Optional.of(GameMode.SPECTATOR);
                default -> Optional.empty();
            };
        }
        catch (NumberFormatException numberFormatException) {
            return Arrays.stream(GameMode.values()).filter(gameMode -> gameMode.name().toLowerCase().startsWith(input.toLowerCase())).findFirst();
        }
    }

    @Override
    public String getSyntaxPath(Command command) {
        String commandName;
        if (command == null) {
            return "GameMode";
        }
        return switch (commandName = command.getName().toLowerCase()) {
            case "gms" -> "GMS";
            case "gmc" -> "GMC";
            case "gma" -> "GMA";
            case "gmsp" -> "GMSP";
            default -> "GameMode";
        };
    }

    @Override
    public boolean hasCommandAccess(Player player, Command command) {
        return PermissionManager.hasCommandPermission((CommandSender)player, "GameMode.Use", false);
    }
}

