/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.home.user;

import java.util.Optional;
import me.testaccount666.serversystem.commands.ServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.AbstractServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.home.admin.CommandAdminHome;
import me.testaccount666.serversystem.commands.executables.home.user.TabCompleterHome;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.userdata.ConsoleUser;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.userdata.home.Home;
import me.testaccount666.serversystem.userdata.home.HomeManager;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@ServerSystemCommand(name="home", variants={"sethome", "deletehome", "adminhome", "adminsethome", "admindeletehome"}, tabCompleter=TabCompleterHome.class)
public class CommandHome
extends AbstractServerSystemCommand {
    private final CommandAdminHome _commandAdminHome = new CommandAdminHome();

    @Override
    public void execute(User commandSender, Command command, String label, String ... arguments) {
        if (command.getName().toLowerCase().startsWith("admin")) {
            this._commandAdminHome.execute(commandSender, command, label, arguments);
            return;
        }
        if (commandSender instanceof ConsoleUser) {
            MessageBuilder.general("NotPlayer", commandSender).build();
            return;
        }
        if (command.getName().equalsIgnoreCase("sethome")) {
            this.handleSetHomeCommand(commandSender, label, arguments);
            return;
        }
        if (command.getName().equalsIgnoreCase("deletehome")) {
            this.handleDeleteHomeCommand(commandSender, label, arguments);
            return;
        }
        this.handleHomeCommand(commandSender, label, arguments);
    }

    private void handleHomeCommand(User commandSender, String label, String ... arguments) {
        if (!this.checkBasePermission(commandSender, "Home.Use")) {
            return;
        }
        if (arguments.length == 0) {
            MessageBuilder.general("InvalidArguments", commandSender).syntaxPath(this.getSyntaxPath(null)).label(label).build();
            return;
        }
        HomeManager homeManager = commandSender.getHomeManager();
        Optional<Home> homeOptional = homeManager.getHomeByName(arguments[0]);
        if (homeOptional.isEmpty()) {
            MessageBuilder.command("Home.DoesNotExist", commandSender).postModifier(message -> message.replace("<HOME>", arguments[0])).build();
            return;
        }
        Home home = homeOptional.get();
        Location homeLocation = home.getLocation();
        commandSender.getPlayer().teleport(homeLocation);
        MessageBuilder.command("Home.Success", commandSender).postModifier(message -> message.replace("<HOME>", home.getDisplayName())).build();
    }

    private void handleDeleteHomeCommand(User commandSender, String label, String ... arguments) {
        if (!this.checkBasePermission(commandSender, "Home.Delete")) {
            return;
        }
        if (arguments.length == 0) {
            MessageBuilder.general("InvalidArguments", commandSender).syntaxPath(this.getSyntaxPath(null)).label(label).build();
            return;
        }
        HomeManager homeManager = commandSender.getHomeManager();
        Optional<Home> homeOptional = homeManager.getHomeByName(arguments[0]);
        if (homeOptional.isEmpty()) {
            MessageBuilder.command("Home.DoesNotExist", commandSender).postModifier(message -> message.replace("<HOME>", arguments[0])).build();
            return;
        }
        Home home = homeOptional.get();
        homeManager.removeHome(home);
        MessageBuilder.command("DeleteHome.Success", commandSender).postModifier(message -> message.replace("<HOME>", home.getDisplayName())).build();
    }

    private void handleSetHomeCommand(User commandSender, String label, String ... arguments) {
        if (!this.checkBasePermission(commandSender, "Home.Set")) {
            return;
        }
        if (arguments.length == 0) {
            MessageBuilder.general("InvalidArguments", commandSender).syntaxPath(this.getSyntaxPath(null)).label(label).build();
            return;
        }
        HomeManager homeManager = commandSender.getHomeManager();
        Optional<Integer> maxHomesOptional = homeManager.getMaxHomeCount();
        if (maxHomesOptional.isEmpty()) {
            MessageBuilder.general("ErrorOccurred", commandSender).label(label).build();
            return;
        }
        int currentHomeCount = homeManager.getHomes().size();
        Integer maxHomes = maxHomesOptional.get();
        if (maxHomes <= currentHomeCount) {
            MessageBuilder.command("SetHome.MaxHomes", commandSender).postModifier(message -> message.replace("<MAX_HOMES>", String.valueOf(maxHomes)).replace("<CURRENT_HOMES>", String.valueOf(currentHomeCount))).build();
            return;
        }
        String homeName = arguments[0];
        if (homeManager.hasHome(homeName)) {
            MessageBuilder.command("SetHome.AlreadyExists", commandSender).postModifier(message -> message.replace("<HOME>", homeName)).build();
            return;
        }
        Optional<Home> newHomeOptional = Home.of(homeName, commandSender.getPlayer().getLocation());
        if (newHomeOptional.isEmpty()) {
            MessageBuilder.command("SetHome.InvalidName", commandSender).build();
            return;
        }
        Home newHome = newHomeOptional.get();
        homeManager.addHome(newHome);
        MessageBuilder.command("SetHome.Success", commandSender).postModifier(message -> message.replace("<HOME>", newHome.getDisplayName())).build();
    }

    @Override
    public String getSyntaxPath(Command command) {
        return "Home";
    }

    @Override
    public boolean hasCommandAccess(Player player, Command command) {
        if (command.getName().toLowerCase().startsWith("admin")) {
            return this._commandAdminHome.hasCommandAccess(player, command);
        }
        if (command.getName().equalsIgnoreCase("sethome")) {
            return PermissionManager.hasCommandPermission((CommandSender)player, "Home.Set", false);
        }
        if (command.getName().equalsIgnoreCase("deletehome")) {
            return PermissionManager.hasCommandPermission((CommandSender)player, "Home.Delete", false);
        }
        return PermissionManager.hasCommandPermission((CommandSender)player, "Home.Use", false);
    }
}

