/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.kit;

import java.util.Optional;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.commands.ServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.AbstractServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.kit.TabCompleterKit;
import me.testaccount666.serversystem.commands.executables.kit.manager.Kit;
import me.testaccount666.serversystem.commands.executables.kit.manager.KitManager;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.userdata.ConsoleUser;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.utils.DurationParser;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

@ServerSystemCommand(name="kit", variants={"createkit", "deletekit"}, tabCompleter=TabCompleterKit.class)
public class CommandKit
extends AbstractServerSystemCommand {
    @Override
    public void execute(User commandSender, Command command, String label, String ... arguments) {
        if (arguments.length == 0) {
            MessageBuilder.general("InvalidArguments", commandSender).syntaxPath(this.getSyntaxPath(command)).label(label).build();
            return;
        }
        if (commandSender instanceof ConsoleUser) {
            MessageBuilder.general("NotPlayer", commandSender).build();
            return;
        }
        String permissionPath = this.getPermission(command);
        if (!this.checkBasePermission(commandSender, permissionPath)) {
            return;
        }
        switch (command.getName().toLowerCase()) {
            case "createkit": {
                this.handleCreateKit(commandSender, label, arguments);
                break;
            }
            case "deletekit": {
                this.handleDeleteKit(commandSender, label, arguments);
                break;
            }
            case "kit": {
                this.handleKit(commandSender, label, arguments);
            }
        }
    }

    private void handleCreateKit(User commandSender, String label, String ... arguments) {
        String kitName = arguments[0].toLowerCase();
        KitManager kitManager = ServerSystem.Instance.getKitManager();
        Optional<Kit> kitOptional = kitManager.getKit(kitName);
        if (kitOptional.isPresent()) {
            MessageBuilder.command("Kit.Create.KitAlreadyExists", commandSender).postModifier(message -> message.replace("<KIT>", ((Kit)kitOptional.get()).getDisplayName())).build();
            return;
        }
        long cooldown = -1L;
        if (arguments.length > 1) {
            cooldown = DurationParser.parseDuration(arguments[1]);
        }
        if (cooldown == -2L) {
            MessageBuilder.command("Kit.Create.InvalidCooldown", commandSender).build();
            return;
        }
        Player player = commandSender.getPlayer();
        PlayerInventory inventory = player.getInventory();
        ItemStack offHandItem = inventory.getItemInOffHand();
        ItemStack[] armorContents = inventory.getArmorContents();
        ItemStack[] contents = inventory.getContents();
        Kit kit = new Kit(kitName, cooldown, offHandItem, armorContents, contents);
        kitManager.addKit(kit);
        kitManager.saveAllKits();
        MessageBuilder.command("Kit.Create.Success", commandSender).postModifier(message -> message.replace("<KIT>", kit.getDisplayName())).build();
    }

    private void handleDeleteKit(User commandSender, String label, String ... arguments) {
        String kitName = arguments[0].toLowerCase();
        KitManager kitManager = ServerSystem.Instance.getKitManager();
        if (!kitManager.kitExists(kitName)) {
            MessageBuilder.command("Kit.KitNotFound", commandSender).postModifier(message -> message.replace("<KIT>", arguments[0])).build();
            return;
        }
        kitManager.removeKit(kitName);
        MessageBuilder.command("Kit.Delete.Success", commandSender).postModifier(message -> message.replace("<KIT>", arguments[0])).build();
    }

    private void handleKit(User commandSender, String label, String ... arguments) {
        boolean isSelf;
        String kitName = arguments[0].toLowerCase();
        KitManager kitManager = ServerSystem.Instance.getKitManager();
        Optional<Kit> kitOptional = kitManager.getKit(kitName);
        if (kitOptional.isEmpty()) {
            MessageBuilder.command("Kit.KitNotFound", commandSender).postModifier(message -> message.replace("<KIT>", arguments[0])).build();
            return;
        }
        Kit kit = kitOptional.get();
        Optional<User> userOptional = this.getTargetUser(commandSender, 1, arguments);
        if (userOptional.isEmpty()) {
            MessageBuilder.general("PlayerNotFound", commandSender).target(arguments[1]).build();
            return;
        }
        User targetUser = userOptional.get();
        Player targetPlayer = targetUser.getPlayer();
        boolean bl = isSelf = targetUser == commandSender;
        if (!isSelf && !this.checkOtherPermission(commandSender, "Kit.Other", targetPlayer.getName())) {
            return;
        }
        if (isSelf && commandSender.isOnKitCooldown(kitName)) {
            long cooldown = commandSender.getKitCooldown(kitName);
            MessageBuilder.command("Kit.OnCooldown", commandSender).postModifier(message -> message.replace("<KIT>", kit.getDisplayName()).replace("<DATE>", DurationParser.parseDate(cooldown, commandSender))).build();
            return;
        }
        if (isSelf) {
            commandSender.setKitCooldown(kitName, kit.getCoolDown());
        }
        kit.giveKit(targetPlayer);
        String messagePath = "Kit.Success." + (isSelf ? "Self" : "Other");
        MessageBuilder.command(messagePath, commandSender).target(targetPlayer.getName()).postModifier(message -> message.replace("<KIT>", kit.getDisplayName())).build();
    }

    private String getPermission(Command command) {
        return switch (command.getName().toLowerCase()) {
            case "createkit" -> "Kit.Create";
            case "deletekit" -> "Kit.Delete";
            case "kit" -> "Kit.Use";
            default -> null;
        };
    }

    @Override
    public boolean hasCommandAccess(Player player, Command command) {
        String permissionPath = this.getPermission(command);
        return PermissionManager.hasCommandPermission((CommandSender)player, permissionPath, false);
    }

    @Override
    public String getSyntaxPath(Command command) {
        String commandName;
        return switch (commandName = command.getName().toLowerCase()) {
            case "createkit" -> "CreateKit";
            case "deletekit" -> "DeleteKit";
            case "kit" -> "Kit";
            default -> throw new IllegalStateException("(CommandKit) Unexpected value: " + commandName);
        };
    }
}

