/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.language;

import java.io.File;
import java.nio.file.Path;
import me.testaccount666.serversystem.commands.ServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.AbstractServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.language.TabCompleterLanguages;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.userdata.ConsoleUser;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@ServerSystemCommand(name="language", tabCompleter=TabCompleterLanguages.class)
public class CommandLanguage
extends AbstractServerSystemCommand {
    private final File _messagesDirectory = Path.of("plugins", "ServerSystem", "messages").toFile();

    @Override
    public void execute(User commandSender, Command command, String label, String ... arguments) {
        if (!this.checkBasePermission(commandSender, "Language.Use")) {
            return;
        }
        if (commandSender instanceof ConsoleUser) {
            MessageBuilder.general("NotPlayer", commandSender).build();
            return;
        }
        if (arguments.length == 0) {
            MessageBuilder.general("InvalidArguments", commandSender).syntaxPath(this.getSyntaxPath(command)).label(label).build();
            return;
        }
        String language = arguments[0];
        File[] languages = this._messagesDirectory.listFiles();
        if (languages == null) {
            languages = new File[]{};
        }
        String selectedLanguage = "English";
        for (File file : languages) {
            String fileName = file.getName();
            if (!fileName.toLowerCase().startsWith(language.toLowerCase())) continue;
            selectedLanguage = fileName;
        }
        commandSender.setPlayerLanguage(selectedLanguage.toLowerCase());
        commandSender.setUsesDefaultLanguage(false);
        commandSender.save();
        char[] chars = selectedLanguage.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        String finalSelectedLanguage = selectedLanguage = new String(chars);
        MessageBuilder.command("Language.Changed", commandSender).postModifier(message -> message.replace("<LANGUAGE>", finalSelectedLanguage)).build();
    }

    @Override
    public String getSyntaxPath(Command command) {
        return "Language";
    }

    @Override
    public boolean hasCommandAccess(Player player, Command command) {
        return PermissionManager.hasCommandPermission((CommandSender)player, "Language.Use", false);
    }
}

