/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.moderation.ban;

import java.util.Optional;
import java.util.Set;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.annotations.RequiredCommands;
import me.testaccount666.serversystem.commands.executables.moderation.ModerationUtils;
import me.testaccount666.serversystem.commands.executables.moderation.ban.CommandBan;
import me.testaccount666.serversystem.commands.interfaces.ServerSystemCommandExecutor;
import me.testaccount666.serversystem.moderation.AbstractModeration;
import me.testaccount666.serversystem.moderation.AbstractModerationManager;
import me.testaccount666.serversystem.userdata.CachedUser;
import me.testaccount666.serversystem.userdata.OfflineUser;
import me.testaccount666.serversystem.userdata.UserManager;
import me.testaccount666.serversystem.utils.DurationParser;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;

@RequiredCommands(requiredCommands={CommandBan.class})
public class ListenerBan
implements Listener {
    public boolean canRegister(Set<ServerSystemCommandExecutor> requiredCommands) {
        return requiredCommands.stream().anyMatch(CommandBan.class::isInstance);
    }

    @EventHandler
    public void onLogin(AsyncPlayerPreLoginEvent event) {
        Optional<CachedUser> userOptional = ServerSystem.Instance.getUserManager().getUser(event.getUniqueId());
        if (userOptional.isEmpty()) {
            ServerSystem.getLog().severe("(ListenerBan) User not found! This should not happen!");
            return;
        }
        CachedUser cachedUser = userOptional.get();
        OfflineUser user = cachedUser.getOfflineUser();
        AbstractModerationManager banManager = user.getBanManager();
        Optional<AbstractModeration> banModerationOptional = banManager.getActiveModeration();
        if (banModerationOptional.isEmpty()) {
            return;
        }
        AbstractModeration banModeration = banModerationOptional.get();
        String senderName = banModeration.senderUuid().toString();
        Optional<String> senderNameOptional = ModerationUtils.findSenderName(banModeration);
        if (senderNameOptional.isPresent()) {
            senderName = senderNameOptional.get();
        }
        long parsedDuration = banModeration.expireTime();
        String unbanDate = DurationParser.parseDate(parsedDuration, user);
        Optional<String> kickOptional = MessageBuilder.command("Moderation.Ban.Kick", UserManager.getConsoleUser()).sender(senderName).target(user.getName().get()).prefix(false).send(false).postModifier(message -> message.replace("<DATE>", unbanDate).replace("<REASON>", banModeration.reason())).build();
        if (kickOptional.isEmpty()) {
            ServerSystem.getLog().severe("(CommandBan) Kick message is empty! This should not happen!");
            event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_BANNED, "Error occurred!");
            return;
        }
        String kickMessage = kickOptional.get();
        event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_BANNED, kickMessage);
        ServerSystem.getLog().info("(ListenerBan) Disallowed " + event.getName() + " (" + String.valueOf(event.getUniqueId()) + ") for " + banModeration.reason());
    }
}

