/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.pay;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Optional;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.commands.ServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.AbstractServerSystemCommand;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.userdata.money.AbstractBankAccount;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@ServerSystemCommand(name="pay")
public class CommandPay
extends AbstractServerSystemCommand {
    @Override
    public void execute(User commandSender, Command command, String label, String ... arguments) {
        boolean isSelf;
        if (!this.checkBasePermission(commandSender, "Pay.Use")) {
            return;
        }
        if (this.handleConsoleWithNoTarget(commandSender, this.getSyntaxPath(command), label, 1, arguments)) {
            return;
        }
        if (arguments.length < 2) {
            MessageBuilder.general("InvalidArguments", commandSender).syntaxPath(this.getSyntaxPath(command)).label(label).build();
            return;
        }
        Optional<User> targetUserOptional = this.getTargetUser(commandSender, arguments);
        if (targetUserOptional.isEmpty()) {
            MessageBuilder.general("PlayerNotFound", commandSender).target(arguments[0]).build();
            return;
        }
        User targetUser = targetUserOptional.get();
        Player targetPlayer = targetUser.getPlayer();
        boolean bl = isSelf = targetUser == commandSender;
        if (isSelf) {
            MessageBuilder.command("Pay.CannotPaySelf", commandSender).build();
            return;
        }
        try {
            BigDecimal amount = BigDecimal.valueOf(Double.parseDouble(arguments[1]));
            amount = amount.setScale(2, RoundingMode.HALF_UP);
            AbstractBankAccount bankAccount = commandSender.getBankAccount();
            if (!bankAccount.hasEnoughMoney(amount)) {
                MessageBuilder.command("Pay.NotEnoughMoney", commandSender).target(targetPlayer.getName()).build();
                return;
            }
            bankAccount.withdraw(amount);
            targetUser.getBankAccount().deposit(amount);
            String formattedAmount = ServerSystem.Instance.getEconomyProvider().formatMoney(amount);
            MessageBuilder.command("Pay.Success", commandSender).target(targetPlayer.getName()).postModifier(message -> message.replace("<AMOUNT>", formattedAmount)).build();
            MessageBuilder.command("Pay.SuccessOther", targetUser).target(targetPlayer.getName()).sender(commandSender.getName().get()).postModifier(message -> message.replace("<AMOUNT>", formattedAmount)).build();
        }
        catch (NumberFormatException ignored) {
            MessageBuilder.command("Pay.InvalidAmount", commandSender).target(targetPlayer.getName()).build();
        }
    }

    @Override
    public String getSyntaxPath(Command command) {
        return "Pay";
    }

    @Override
    public boolean hasCommandAccess(Player player, Command command) {
        return PermissionManager.hasCommandPermission((CommandSender)player, "Pay.Use", false);
    }
}

