/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.privatemessage;

import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.commands.ServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.AbstractServerSystemCommand;
import me.testaccount666.serversystem.events.UserPrivateMessageEvent;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.managers.messages.MessageManager;
import me.testaccount666.serversystem.userdata.ConsoleUser;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.utils.ComponentColor;
import me.testaccount666.serversystem.utils.MessageBuilder;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickEvent;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@ServerSystemCommand(name="privatemessage", variants={"reply", "messagetoggle", "socialspy"})
public class CommandPrivateMessage
extends AbstractServerSystemCommand {
    private String _privateMessageCommand = null;

    @Override
    public void execute(User commandSender, Command command, String label, String ... arguments) {
        String commandName;
        switch (commandName = command.getName().toLowerCase()) {
            case "socialspy": {
                this.handleSocialSpyCommand(commandSender, command, label, arguments);
                break;
            }
            case "messagetoggle": {
                this.handleMessageToggleCommand(commandSender, command, label, arguments);
                break;
            }
            case "privatemessage": {
                this.handlePrivateMessageCommand(commandSender, command, label, arguments);
                break;
            }
            default: {
                this.handleReplyCommand(commandSender, command, label, arguments);
            }
        }
    }

    private void handleSocialSpyCommand(User commandSender, Command command, String label, String ... arguments) {
        boolean isSelf;
        if (!this.checkBasePermission(commandSender, "SocialSpy.Use")) {
            return;
        }
        if (this.handleConsoleWithNoTarget(commandSender, this.getSyntaxPath(command), label, arguments)) {
            return;
        }
        Optional<User> targetUserOptional = this.getTargetUser(commandSender, arguments);
        if (targetUserOptional.isEmpty()) {
            MessageBuilder.general("PlayerNotFound", commandSender).target(arguments[0]).build();
            return;
        }
        User targetUser = targetUserOptional.get();
        Player targetPlayer = targetUser.getPlayer();
        boolean bl = isSelf = targetUser == commandSender;
        if (!isSelf && !this.checkOtherPermission(commandSender, "SocialSpy.Other", targetPlayer.getName())) {
            return;
        }
        boolean isEnabled = !targetUser.isSocialSpyEnabled();
        Object messagePath = isSelf ? "SocialSpy.Success" : "SocialSpy.SuccessOther";
        messagePath = (String)messagePath + (isEnabled ? ".Enabled" : ".Disabled");
        targetUser.setSocialSpyEnabled(isEnabled);
        targetUser.save();
        MessageBuilder.command((String)messagePath, commandSender).target(targetPlayer.getName()).build();
        if (isSelf) {
            return;
        }
        MessageBuilder.command("SocialSpy.Success." + (isEnabled ? "Enabled" : "Disabled"), targetUser).build();
    }

    private void handleMessageToggleCommand(User commandSender, Command command, String label, String ... arguments) {
        boolean isSelf;
        if (!this.checkBasePermission(commandSender, "PrivateMessage.Toggle.Use")) {
            return;
        }
        if (this.handleConsoleWithNoTarget(commandSender, this.getSyntaxPath(command), label, arguments)) {
            return;
        }
        Optional<User> targetUserOptional = this.getTargetUser(commandSender, arguments);
        if (targetUserOptional.isEmpty()) {
            MessageBuilder.general("PlayerNotFound", commandSender).target(arguments[0]).build();
            return;
        }
        User targetUser = targetUserOptional.get();
        Player targetPlayer = targetUser.getPlayer();
        boolean bl = isSelf = targetUser == commandSender;
        if (!isSelf && !this.checkOtherPermission(commandSender, "PrivateMessage.Toggle.Other", targetPlayer.getName())) {
            return;
        }
        boolean acceptsMessages = !targetUser.isAcceptsMessages();
        targetUser.setAcceptsMessages(acceptsMessages);
        targetUser.save();
        Object messagePath = isSelf ? "MessageToggle.Success" : "MessageToggle.SuccessOther";
        messagePath = acceptsMessages ? (String)messagePath + ".Enabled" : (String)messagePath + ".Disabled";
        MessageBuilder.command((String)messagePath, commandSender).target(targetPlayer.getName()).build();
        if (isSelf) {
            return;
        }
        MessageBuilder.command("MessageToggle.Success" + (acceptsMessages ? "Enabled" : "Disabled"), targetUser).sender(commandSender.getName().get()).build();
    }

    private void handleReplyCommand(User commandSender, Command command, String label, String ... arguments) {
        if (!this.checkBasePermission(commandSender, "PrivateMessage.Use")) {
            return;
        }
        if (arguments.length == 0) {
            MessageBuilder.general("InvalidArguments", commandSender).syntaxPath(this.getSyntaxPath(command)).label(label).build();
            return;
        }
        User targerUser = commandSender.getReplyUser();
        if (!this.isValidReplyTarget(targerUser)) {
            MessageBuilder.command("Reply.NoReply", commandSender).build();
            return;
        }
        String[] newArguments = new String[arguments.length + 1];
        newArguments[0] = targerUser.getName().get();
        System.arraycopy(arguments, 0, newArguments, 1, arguments.length);
        this.sendPrivateMessage(commandSender, targerUser, label, newArguments);
    }

    private void handlePrivateMessageCommand(User commandSender, Command command, String label, String ... arguments) {
        if (this._privateMessageCommand == null) {
            this._privateMessageCommand = label;
        }
        if (!this.checkBasePermission(commandSender, "PrivateMessage.Use")) {
            return;
        }
        if (arguments.length <= 1) {
            MessageBuilder.general("InvalidArguments", commandSender).syntaxPath(this.getSyntaxPath(command)).label(label).build();
            return;
        }
        Optional<User> targetUserOptional = this.getTargetUser(commandSender, arguments);
        if (targetUserOptional.isEmpty()) {
            MessageBuilder.general("PlayerNotFound", commandSender).target(arguments[0]).build();
            return;
        }
        User targetUser = targetUserOptional.get();
        this.sendPrivateMessage(commandSender, targetUser, label, arguments);
    }

    private void sendPrivateMessage(User commandSender, User targetUser, String label, String ... arguments) {
        boolean isSelf;
        Optional<String> nameOptional = targetUser.getName();
        if (nameOptional.isEmpty()) {
            MessageBuilder.general("ErrorOccurred", commandSender).label(label).target(targetUser.getUuid().toString()).build();
            return;
        }
        String targetName = nameOptional.get();
        boolean bl = isSelf = targetUser == commandSender;
        if (isSelf) {
            MessageBuilder.command("PrivateMessage.CannotSendToSelf", commandSender).build();
            return;
        }
        if (!targetUser.isAcceptsMessages()) {
            MessageBuilder.command("PrivateMessage.NoMessages", commandSender).target(targetName).build();
            return;
        }
        String message = IntStream.range(1, arguments.length).mapToObj(index -> arguments[index] + " ").collect(Collectors.joining()).trim();
        Optional<String> successOptional = MessageBuilder.command("PrivateMessage.Success", commandSender).format(false).target(targetName).prefix(false).send(false).postModifier(msg -> MessageManager.applyPlaceholders(msg, commandSender, targetName, label).replace("<MESSAGE>", message)).build();
        Optional<String> successOtherOptional = MessageBuilder.command("PrivateMessage.SuccessOther", targetUser).sender(commandSender.getName().get()).prefix(false).send(false).postModifier(msg -> MessageManager.applyPlaceholders(msg, targetUser, targetName, label).replace("<MESSAGE>", message)).build();
        if (successOptional.isEmpty() || successOtherOptional.isEmpty()) {
            ServerSystem.getLog().warning("Couldn't find message for path Commands.PrivateMessage.Success or Commands.PrivateMessage.SuccessOther");
            MessageBuilder.general("ErrorOccurred", commandSender).label(label).target(targetName).build();
            return;
        }
        UserPrivateMessageEvent messageEvent = new UserPrivateMessageEvent(commandSender, message, targetUser);
        Bukkit.getPluginManager().callEvent((Event)messageEvent);
        if (messageEvent.isCancelled()) {
            return;
        }
        String success = successOptional.get();
        String successOther = successOtherOptional.get();
        Component successComponent = ComponentColor.translateToComponent(success).clickEvent(ClickEvent.suggestCommand((String)("/" + this._privateMessageCommand + " " + targetName + " "))).asComponent();
        Component successOtherComponent = ComponentColor.translateToComponent(successOther).clickEvent(ClickEvent.suggestCommand((String)("/" + this._privateMessageCommand + " " + commandSender.getName().get() + " "))).asComponent();
        messageEvent.getRecipients().forEach(recipient -> {
            if (recipient == commandSender) {
                commandSender.sendMessage(successComponent);
                commandSender.setReplyUser(targetUser);
                return;
            }
            if (recipient == targetUser && targetUser.isIgnoredPlayer(commandSender.getUuid())) {
                return;
            }
            recipient.sendMessage(successOtherComponent);
            recipient.setReplyUser(commandSender);
        });
    }

    private boolean isValidReplyTarget(User targetUser) {
        if (targetUser == null || targetUser.getCommandSender() == null || targetUser.getName().isEmpty()) {
            return false;
        }
        if (targetUser instanceof ConsoleUser) {
            return true;
        }
        return targetUser.getPlayer() != null && targetUser.getPlayer().isOnline();
    }

    @Override
    public String getSyntaxPath(Command command) {
        String commandName;
        return switch (commandName = command.getName().toLowerCase()) {
            case "privatemessage" -> "PrivateMessage";
            case "reply" -> "Reply";
            case "messagetoggle" -> "MessageToggle";
            case "socialspy" -> "SocialSpy";
            default -> throw new IllegalStateException("(CommandPrivateMessage) Unexpected value: " + commandName);
        };
    }

    @Override
    public boolean hasCommandAccess(Player player, Command command) {
        String permissionPath = switch (command.getName().toLowerCase()) {
            case "privatemessage" -> "PrivateMessage.Use";
            case "reply" -> "PrivateMessage.Use";
            case "messagetoggle" -> "PrivateMessage.Toggle.Use";
            case "socialspy" -> "SocialSpy.Use";
            default -> throw new IllegalStateException("(CommandPrivateMessage) Unexpected value: " + command.getName().toLowerCase());
        };
        return PermissionManager.hasCommandPermission((CommandSender)player, permissionPath, false);
    }
}

