/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.skull;

import com.destroystokyo.paper.profile.PlayerProfile;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Base64;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerTextures;

public class SkullCreator {
    public ItemStack getSkull(UUID uuid) {
        PlayerProfile playerProfile = Bukkit.createProfile((UUID)uuid);
        return this.getSkullByPlayerProfile(playerProfile);
    }

    public ItemStack getSkull(String name) {
        PlayerProfile playerProfile = Bukkit.createProfile((String)name);
        return this.getSkullByPlayerProfile(playerProfile);
    }

    public ItemStack getSkull(OfflinePlayer offlinePlayer) {
        PlayerProfile playerProfile = offlinePlayer.getPlayerProfile();
        return this.getSkullByPlayerProfile(playerProfile);
    }

    public ItemStack getSkullByTexture(String base64) {
        try {
            return this.getSkullByTexture(URI.create(new String(Base64.getDecoder().decode(base64))).toURL());
        }
        catch (MalformedURLException exception) {
            throw new RuntimeException(exception);
        }
    }

    public ItemStack getSkullByTexture(URL textureURL) {
        PlayerProfile playerProfile = Bukkit.getServer().createProfile(UUID.randomUUID(), "NiceSkull");
        PlayerTextures playerTextures = playerProfile.getTextures();
        playerTextures.setSkin(textureURL, PlayerTextures.SkinModel.CLASSIC);
        playerProfile.setTextures(playerTextures);
        return this.getSkullByPlayerProfile(playerProfile);
    }

    private ItemStack getSkullByPlayerProfile(PlayerProfile playerProfile) {
        ItemStack skullItem = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta skullMeta = (SkullMeta)skullItem.getItemMeta();
        assert (skullMeta != null);
        skullMeta.setPlayerProfile(playerProfile);
        skullItem.setItemMeta((ItemMeta)skullMeta);
        return skullItem;
    }
}

