/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.sudo;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.logging.Level;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.commands.ServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.AbstractServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.sudo.IMorpher;
import me.testaccount666.serversystem.commands.executables.sudo.MessageInterceptor;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.userdata.CachedUser;
import me.testaccount666.serversystem.userdata.ConsoleUser;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.utils.MessageBuilder;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.ModifierReviewable;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodCall;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.bind.annotation.Morph;
import net.bytebuddy.implementation.bind.annotation.TargetMethodAnnotationDrivenBinder;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.permissions.PermissibleBase;

@ServerSystemCommand(name="sudo")
public class CommandSudo
extends AbstractServerSystemCommand {
    private static Method _GetHandleMethod;

    @Override
    public void execute(User commandSender, Command command, String label, String ... arguments) {
        boolean isSelf;
        if (!this.checkBasePermission(commandSender, "Sudo.Use")) {
            return;
        }
        if (this.handleConsoleWithNoTarget(commandSender, this.getSyntaxPath(command), label, arguments)) {
            return;
        }
        Optional<User> targetUserOptional = this.getTargetUser(commandSender, false, arguments);
        if (targetUserOptional.isEmpty()) {
            MessageBuilder.general("PlayerNotFound", commandSender).target(arguments[0]).build();
            return;
        }
        User targetUser = targetUserOptional.get();
        Player targetPlayer = targetUser.getPlayer();
        boolean bl = isSelf = targetUser == commandSender;
        if (isSelf) {
            MessageBuilder.command("Sudo.CannotSudoSelf", commandSender).build();
            return;
        }
        if (arguments.length <= 1) {
            MessageBuilder.general("InvalidArguments", commandSender).syntaxPath(this.getSyntaxPath(command)).label(label).build();
            return;
        }
        String sudoCommand = arguments[1];
        if (sudoCommand.isBlank()) {
            MessageBuilder.general("InvalidArguments", commandSender).syntaxPath(this.getSyntaxPath(command)).label(label).build();
            return;
        }
        if (!(commandSender instanceof ConsoleUser) && PermissionManager.hasCommandPermission((CommandSender)targetPlayer, "Sudo.Exempt", false)) {
            MessageBuilder.command("Sudo.CannotSudoExempt", commandSender).target(targetPlayer.getName()).build();
            return;
        }
        Optional<CachedUser> cachedSenderOptional = ServerSystem.Instance.getUserManager().getUser(commandSender.getUuid());
        if (cachedSenderOptional.isEmpty()) {
            ServerSystem.getLog().warning("(CommandSudo) Couldn't find cached command sender?!");
            MessageBuilder.general("ErrorOccurred", commandSender).label(label).build();
            return;
        }
        CachedUser cachedSender = cachedSenderOptional.get();
        targetUser.addMessageListener(cachedSender);
        MessageBuilder.command("Sudo.Success", commandSender).target(targetPlayer.getName()).postModifier(message -> message.replace("<COMMAND>", sudoCommand)).build();
        if (!sudoCommand.startsWith("/")) {
            targetPlayer.chat(sudoCommand);
            return;
        }
        Player hookedTargetPlayer = this.createHookedPlayer(targetPlayer, commandSender.getCommandSender());
        if (hookedTargetPlayer == null) {
            MessageBuilder.general("ErrorOccurred", commandSender).label(label).build();
            return;
        }
        String[] sudoArguments = new String[arguments.length - 2];
        System.arraycopy(arguments, 2, sudoArguments, 0, sudoArguments.length);
        Optional<Command> commandOptional = ServerSystem.Instance.getCommandManager().getCommand(sudoCommand.substring(1));
        if (commandOptional.isEmpty()) {
            ArrayList<String> tempArgumentList = new ArrayList<String>();
            tempArgumentList.add(sudoCommand);
            tempArgumentList.addAll(Arrays.stream(sudoArguments).toList());
            PlayerCommandPreprocessEvent commandEvent = new PlayerCommandPreprocessEvent(hookedTargetPlayer, String.join((CharSequence)" ", tempArgumentList).trim());
            Bukkit.getPluginManager().callEvent((Event)commandEvent);
            targetUser.removeMessageListener(cachedSender);
            return;
        }
        Command foundCommand = commandOptional.get();
        foundCommand.execute((CommandSender)hookedTargetPlayer, sudoCommand.substring(1), sudoArguments);
        targetUser.removeMessageListener(cachedSender);
    }

    private Player createHookedPlayer(Player targetPlayer, CommandSender commandSender) {
        DynamicType.Unloaded hookedPlayer = new ByteBuddy().subclass(targetPlayer.getClass()).method((ElementMatcher)ElementMatchers.named((String)"sendMessage").and(ModifierReviewable.OfByteCodeElement::isPublic)).intercept((Implementation)MethodCall.invokeSuper().withAllArguments().andThen((Implementation.Composable)MethodDelegation.withDefaultConfiguration().withBinders(new TargetMethodAnnotationDrivenBinder.ParameterBinder[]{Morph.Binder.install(IMorpher.class)}).to((Object)new MessageInterceptor(commandSender)))).make();
        try {
            Class loadedClass = hookedPlayer.load(this.getClass().getClassLoader()).getLoaded();
            if (_GetHandleMethod == null) {
                try {
                    _GetHandleMethod = targetPlayer.getClass().getDeclaredMethod("getHandle", new Class[0]);
                    _GetHandleMethod.setAccessible(true);
                }
                catch (NoSuchMethodException exception) {
                    ServerSystem.getLog().log(Level.WARNING, "(CommandSudo) Couldn't find getHandle method!", exception);
                    Player player = null;
                    if (hookedPlayer != null) {
                        hookedPlayer.close();
                    }
                    return player;
                }
            }
            try {
                Field permField = Class.forName("org.bukkit.craftbukkit.entity.CraftHumanEntity").getDeclaredField("perm");
                permField.setAccessible(true);
                PermissibleBase permissibleBase = (PermissibleBase)permField.get(targetPlayer);
                targetPlayer = (Player)loadedClass.getDeclaredConstructors()[0].newInstance(Bukkit.getServer(), _GetHandleMethod.invoke((Object)targetPlayer, new Object[0]));
                permField.set(targetPlayer, permissibleBase);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchFieldException | InvocationTargetException exception) {
                ServerSystem.getLog().log(Level.WARNING, "(CommandSudo) Couldn't hook player!", exception);
                Player player = null;
                if (hookedPlayer != null) {
                    hookedPlayer.close();
                }
                return player;
            }
        }
        finally {
            if (hookedPlayer != null) {
                try {
                    hookedPlayer.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
        return targetPlayer;
    }

    @Override
    public String getSyntaxPath(Command command) {
        return "Sudo";
    }

    @Override
    public boolean hasCommandAccess(Player player, Command command) {
        return PermissionManager.hasCommandPermission((CommandSender)player, "Sudo.Use", false);
    }
}

