/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.warp;

import java.util.List;
import java.util.Optional;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.commands.executables.warp.manager.Warp;
import me.testaccount666.serversystem.commands.interfaces.ServerSystemTabCompleter;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.userdata.User;
import org.bukkit.command.Command;

public class TabCompleterWarp
implements ServerSystemTabCompleter {
    @Override
    public Optional<List<String>> tabComplete(User commandSender, Command command, String label, String ... arguments) {
        String permissionPath;
        String commandName = command.getName();
        if (!commandName.equalsIgnoreCase("warp") && !commandName.equalsIgnoreCase("deletewarp")) {
            return Optional.empty();
        }
        switch (commandName) {
            case "warp": {
                String string = "Warp.Use";
                break;
            }
            case "deletewarp": {
                String string = "Warp.Delete";
                break;
            }
            case "setwarp": {
                String string = "Warp.Set";
                break;
            }
            default: {
                String string = permissionPath = null;
            }
        }
        if (!PermissionManager.hasCommandPermission(commandSender, permissionPath, false)) {
            return Optional.of(List.of());
        }
        List<String> potentialCompletions = ServerSystem.Instance.getWarpManager().getWarps().stream().map(Warp::getName).toList();
        List<String> completions = potentialCompletions.stream().filter(completion -> completion.toLowerCase().startsWith(arguments[0].toLowerCase())).toList();
        return Optional.of(completions);
    }
}

