/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.weather;

import java.util.concurrent.ThreadLocalRandom;
import me.testaccount666.serversystem.commands.ServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.AbstractServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.weather.TabCompleterWeather;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.userdata.ConsoleUser;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@ServerSystemCommand(name="weather", variants={"sun", "storm", "rain"}, tabCompleter=TabCompleterWeather.class)
public class CommandWeather
extends AbstractServerSystemCommand {
    @Override
    public void execute(User commandSender, Command command, String label, String ... arguments) {
        World world;
        if (command.getName().equalsIgnoreCase("weather")) {
            this.handleWeatherCommand(commandSender, command, label, arguments);
            return;
        }
        if (commandSender instanceof ConsoleUser && arguments.length == 0) {
            MessageBuilder.general("InvalidArguments", commandSender).syntaxPath(this.getSyntaxPath(command)).label(label).build();
            return;
        }
        if (arguments.length >= 1) {
            if (!this.checkBasePermission(commandSender, "Weather.World")) {
                return;
            }
            world = Bukkit.getWorld((String)arguments[0]);
        } else {
            world = commandSender.getPlayer().getWorld();
        }
        if (world == null) {
            MessageBuilder.command("Weather.WorldNotFound", commandSender).target(arguments[0]).build();
            return;
        }
        this.handleWeatherCommand(commandSender, command, label, command.getName(), world.getName());
    }

    private void handleWeatherCommand(User commandSender, Command command, String label, String ... arguments) {
        World world;
        if (!this.checkBasePermission(commandSender, "Weather.Use")) {
            return;
        }
        if (arguments.length == 0) {
            MessageBuilder.general("InvalidArguments", commandSender).syntaxPath(this.getSyntaxPath(command)).label(label).build();
            return;
        }
        if (commandSender instanceof ConsoleUser && arguments.length == 1) {
            MessageBuilder.general("InvalidArguments", commandSender).syntaxPath(this.getSyntaxPath(command)).label(label).build();
            return;
        }
        if (arguments.length >= 2) {
            if (!this.checkBasePermission(commandSender, "Weather.World")) {
                return;
            }
            world = Bukkit.getWorld((String)arguments[1]);
        } else {
            world = commandSender.getPlayer().getWorld();
        }
        if (world == null) {
            MessageBuilder.command("Weather.WorldNotFound", commandSender).target(arguments[1]).build();
            return;
        }
        ThreadLocalRandom random = ThreadLocalRandom.current();
        int weatherDuration = random.nextInt(300, 900) + 1;
        weatherDuration *= 20;
        switch (arguments[0].toLowerCase()) {
            case "sun": 
            case "clear": {
                world.setThundering(false);
                world.setStorm(false);
                world.setClearWeatherDuration(weatherDuration);
                break;
            }
            case "storm": 
            case "thunder": {
                world.setClearWeatherDuration(0);
                world.setStorm(true);
                world.setThundering(true);
                world.setWeatherDuration(weatherDuration);
                break;
            }
            case "rain": {
                world.setClearWeatherDuration(0);
                world.setThundering(false);
                world.setStorm(true);
                world.setWeatherDuration(weatherDuration);
                break;
            }
            default: {
                MessageBuilder.general("InvalidArguments", commandSender).syntaxPath(this.getSyntaxPath(command)).label(label).build();
                return;
            }
        }
        MessageBuilder.command("Weather.Success", commandSender).target(world.getName()).postModifier(message -> message.replace("<WEATHER>", arguments[0]).replace("<WORLD>", world.getName()));
    }

    @Override
    public String getSyntaxPath(Command command) {
        String commandName;
        return switch (commandName = command.getName().toLowerCase()) {
            case "weather" -> "Weather";
            case "sun" -> "Sun";
            case "storm" -> "Storm";
            case "rain" -> "Rain";
            default -> throw new IllegalStateException("(CommandWeather) Unexpected value: " + commandName);
        };
    }

    @Override
    public boolean hasCommandAccess(Player player, Command command) {
        return PermissionManager.hasCommandPermission((CommandSender)player, "Weather.Use", false);
    }
}

