/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.listener.executables.awayfromkeyboard;

import io.papermc.paper.event.player.AsyncChatEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.userdata.CachedUser;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class ListenerAwayFromKeyboard
implements Listener {
    private final boolean _enabled;
    private final Map<UUID, Long> _lastActionMap = new HashMap<UUID, Long>();
    private final Map<UUID, Location> _chunkLocationMap = new HashMap<UUID, Location>();
    private final Map<UUID, Long> _lastMouseMovement = new HashMap<UUID, Long>();

    public ListenerAwayFromKeyboard() {
        this._enabled = ServerSystem.Instance.getConfigManager().getGeneralConfig().getBoolean("AwayFromKeyboard.Enabled");
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)ServerSystem.Instance, () -> Bukkit.getOnlinePlayers().forEach(player -> {
            long timeOut;
            Long lastAction = this._lastActionMap.getOrDefault(player.getUniqueId(), System.currentTimeMillis());
            long currentTime = System.currentTimeMillis();
            if (currentTime < (timeOut = lastAction + 300000L)) {
                return;
            }
            Optional<User> userOptional = this.getUser((Player)player);
            if (userOptional.isEmpty()) {
                return;
            }
            User user = userOptional.get();
            if (user.isAfk()) {
                return;
            }
            user.setAfk(true);
            MessageBuilder.general("AwayFromKeyboard.NowAfk", user).build();
        }), 1200L, 1200L);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this._lastActionMap.remove(event.getPlayer().getUniqueId());
        this._chunkLocationMap.remove(event.getPlayer().getUniqueId());
        this._lastMouseMovement.remove(event.getPlayer().getUniqueId());
    }

    @EventHandler
    public void onPlayerFish(PlayerFishEvent event) {
        if (!this._enabled) {
            return;
        }
        if (event.getState() == PlayerFishEvent.State.FISHING) {
            return;
        }
        this._lastActionMap.put(event.getPlayer().getUniqueId(), System.currentTimeMillis());
    }

    @EventHandler
    public void onPlayerBreakBlock(BlockBreakEvent event) {
        if (!this._enabled) {
            return;
        }
        if (this.isMouseInactive(event.getPlayer())) {
            event.setCancelled(true);
            return;
        }
        this._lastActionMap.put(event.getPlayer().getUniqueId(), System.currentTimeMillis());
        this.resetAfkStatus(event.getPlayer());
    }

    @EventHandler
    public void onPlayerDamageEntity(EntityDamageByEntityEvent event) {
        if (!this._enabled) {
            return;
        }
        Entity entity = event.getDamager();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (this.isMouseInactive(player)) {
            event.setCancelled(true);
            return;
        }
        this.resetAfkStatus(player);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (!this._enabled) {
            return;
        }
        Player player = event.getPlayer();
        this._chunkLocationMap.put(player.getUniqueId(), this.getChunkLocation(player));
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        if (!this._enabled) {
            return;
        }
        this.handleChunkChange(event.getPlayer());
        this.handleMouseMovement(event.getPlayer(), event.getFrom(), event.getTo());
    }

    private void handleMouseMovement(Player player, Location from, Location to) {
        float fromYaw = from.getYaw();
        float toYaw = to.getYaw();
        float yawDifference = Math.abs(fromYaw - toYaw);
        float fromPitch = from.getPitch();
        float toPitch = to.getPitch();
        float pitchDifference = Math.abs(fromPitch - toPitch);
        if (yawDifference <= 2.0f && pitchDifference <= 2.0f) {
            return;
        }
        this._lastMouseMovement.put(player.getUniqueId(), System.currentTimeMillis());
    }

    private void handleChunkChange(Player player) {
        this._chunkLocationMap.putIfAbsent(player.getUniqueId(), this.getChunkLocation(player));
        Location chunkLocation = this._chunkLocationMap.get(player.getUniqueId());
        Location currentChunkLocation = this.getChunkLocation(player);
        double currentY = currentChunkLocation.getY();
        currentChunkLocation.setY(chunkLocation.getY());
        World currentWorld = currentChunkLocation.getWorld();
        World chunkWorld = chunkLocation.getWorld();
        if (currentWorld != chunkWorld) {
            this._chunkLocationMap.put(player.getUniqueId(), this.getChunkLocation(player));
            this.resetAfkStatus(player);
            return;
        }
        double distance = currentChunkLocation.distance(chunkLocation);
        if (distance < 3.0 && Math.abs(currentY - chunkLocation.getY()) < 70.0) {
            return;
        }
        this._chunkLocationMap.put(player.getUniqueId(), this.getChunkLocation(player));
        this.resetAfkStatus(player);
    }

    @EventHandler
    public void onPlayerContainerOpen(InventoryOpenEvent event) {
        if (!this._enabled) {
            return;
        }
        HumanEntity humanEntity = event.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        this.resetAfkStatus(player);
    }

    @EventHandler
    public void onPlayerChat(AsyncChatEvent event) {
        if (!this._enabled) {
            return;
        }
        this.resetAfkStatus(event.getPlayer());
    }

    @EventHandler
    public void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        if (!this._enabled) {
            return;
        }
        this.resetAfkStatus(event.getPlayer());
    }

    private Optional<User> getUser(Player player) {
        Optional<CachedUser> userOptional = ServerSystem.Instance.getUserManager().getUser(player);
        if (userOptional.isEmpty()) {
            return Optional.empty();
        }
        CachedUser cachedUser = userOptional.get();
        if (cachedUser.isOfflineUser()) {
            return Optional.empty();
        }
        User user = (User)cachedUser.getOfflineUser();
        return Optional.of(user);
    }

    private Location getChunkLocation(Player player) {
        Chunk chunk = player.getLocation().getChunk();
        int chunkX = chunk.getX();
        int chunkY = player.getLocation().getBlockY();
        int chunkZ = chunk.getZ();
        World world = chunk.getWorld();
        return new Location(world, (double)chunkX, (double)chunkY, (double)chunkZ);
    }

    public boolean isMouseInactive(Player player) {
        Long lastMouseMovement = this._lastMouseMovement.getOrDefault(player.getUniqueId(), System.currentTimeMillis());
        long currentTime = System.currentTimeMillis();
        return currentTime > (lastMouseMovement = Long.valueOf(lastMouseMovement + 30000L));
    }

    private void resetAfkStatus(Player player) {
        this._lastActionMap.put(player.getUniqueId(), System.currentTimeMillis());
        Optional<User> userOptional = this.getUser(player);
        if (userOptional.isEmpty()) {
            return;
        }
        User user = userOptional.get();
        if (!user.isAfk()) {
            return;
        }
        user.setAfk(false);
        MessageBuilder.general("AwayFromKeyboard.NoLongerAfk", user).build();
    }
}

