/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.listener.executables.prefixchat;

import java.util.Optional;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.listener.executables.prefixchat.ChatVaultAPI;
import me.testaccount666.serversystem.userdata.CachedUser;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;

public class ListenerPrefixChat
implements Listener {
    private final ChatVaultAPI _chatVaultAPI;
    private final boolean _enabled;

    public ListenerPrefixChat() {
        boolean enabled = ServerSystem.Instance.getConfigManager().getGeneralConfig().getBoolean("Chat.PrefixChat.Enabled");
        if (!ChatVaultAPI.isVaultInstalled() || !enabled) {
            this._chatVaultAPI = null;
            this._enabled = false;
            return;
        }
        this._chatVaultAPI = new ChatVaultAPI();
        this._enabled = this._chatVaultAPI.setupChat();
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        if (!this._enabled) {
            return;
        }
        Player player = event.getPlayer();
        String prefix = this._chatVaultAPI.getChat().getPlayerPrefix(player);
        String suffix = this._chatVaultAPI.getChat().getPlayerSuffix(player);
        if (prefix == null) {
            prefix = "";
        }
        if (suffix == null) {
            suffix = "";
        }
        prefix = prefix.replace("%", "%%");
        suffix = suffix.replace("%", "%%");
        Optional<CachedUser> userOptional = ServerSystem.Instance.getUserManager().getUser(player);
        if (userOptional.isEmpty()) {
            ServerSystem.getLog().warning("Couldn't cache User '" + player.getName() + "'! This should not happen!");
            return;
        }
        CachedUser cachedUser = userOptional.get();
        if (cachedUser.isOfflineUser()) {
            ServerSystem.getLog().warning("User '" + player.getName() + "' is cached as Offline User! This should not happen!");
            return;
        }
        User user = (User)cachedUser.getOfflineUser();
        String finalSuffix = suffix;
        String finalPrefix = prefix;
        Optional<String> chatFormatOptional = MessageBuilder.general("ChatFormat", user).sender("%1$s").prefix(false).send(false).preModifier(message -> message.replace("%", "%%").replace("<PREFIX>", finalPrefix).replace("<SUFFIX>", finalSuffix).replace("<MESSAGE>", "%2$s")).build();
        if (chatFormatOptional.isEmpty()) {
            return;
        }
        String chatFormat = chatFormatOptional.get();
        event.setFormat(chatFormat);
    }
}

