/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.managers;

import java.util.Optional;
import javax.annotation.Nullable;
import me.clip.placeholderapi.PlaceholderAPI;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.managers.messages.MappingsData;
import me.testaccount666.serversystem.userdata.ConsoleUser;
import me.testaccount666.serversystem.userdata.User;
import org.bukkit.entity.Player;

public class PlaceholderManager {
    private boolean _placeholders;

    public PlaceholderManager() {
        try {
            Class.forName("me.clip.placeholderapi.PlaceholderAPI");
            this._placeholders = true;
        }
        catch (Throwable throwable) {
            this._placeholders = false;
        }
    }

    public String applyPlaceholders(String message, User commandSender, @Nullable String targetName, String label) {
        if (commandSender.getName().isEmpty()) {
            ServerSystem.getLog().warning("CommandSender (" + String.valueOf(commandSender.getUuid()) + ") has no name! This should not happen!");
            return message;
        }
        if (targetName == null) {
            targetName = commandSender.getName().get();
        }
        message = this.applyColorPlaceholder(commandSender, message, "<Color:Prefix>", "Prefix");
        message = this.applyColorPlaceholder(commandSender, message, "<Color:Separators>", "Separator");
        message = this.applyColorPlaceholder(commandSender, message, "<Color:Message>", "Message");
        message = this.applyColorPlaceholder(commandSender, message, "<Color:Highlight>", "Highlight");
        message = this.applyColorPlaceholder(commandSender, message, "<Color:Error.Message>", "ErrorMessage");
        message = this.applyColorPlaceholder(commandSender, message, "<Color:Error.Highlight>", "ErrorHighlight");
        message = message.replace("<SENDER>", commandSender.getName().get()).replace("<TARGET>", targetName).replace("<LABEL>", label);
        if (this._placeholders && !(commandSender instanceof ConsoleUser)) {
            message = PlaceholderAPI.setPlaceholders((Player)commandSender.getPlayer(), (String)message);
        }
        return message;
    }

    private String applyColorPlaceholder(User user, String message, String placeholder, String colorId) {
        Optional<String> colorOptional = MappingsData.messageColors(user).getMessageColor(colorId);
        return colorOptional.map(prefixString -> message.replace(placeholder, (CharSequence)prefixString)).orElseGet(() -> {
            ServerSystem.getLog().warning(colorId + " color could not be found! This should not happen!");
            return message;
        });
    }
}

