/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.managers.config;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.managers.config.ConfigReader;
import me.testaccount666.serversystem.utils.FileUtils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class DefaultConfigReader
implements ConfigReader {
    private final Plugin _plugin;
    private final File _file;
    private final FileConfiguration _configuration;
    private FileConfiguration _originalCfg = null;
    private DefaultConfigReader _newReader = null;

    public DefaultConfigReader(File file, Plugin plugin) throws FileNotFoundException {
        this._plugin = plugin;
        this._file = file;
        this._configuration = YamlConfiguration.loadConfiguration((File)file);
        this.loadDefaultConfig();
        if (!this.validateAndFixConfig()) {
            this.createBackupAndSave();
        }
    }

    public static ConfigReader loadConfiguration(File file) throws FileNotFoundException {
        return DefaultConfigReader.loadConfiguration(file, (Plugin)ServerSystem.getPlugin(ServerSystem.class));
    }

    public static ConfigReader loadConfiguration(File file, Plugin plugin) throws FileNotFoundException {
        return new DefaultConfigReader(file, plugin);
    }

    private static Map<Class<?>, String> initializeTypeWarnings() {
        HashMap typeWarnings = new HashMap();
        typeWarnings.put(String.class, "should be a string");
        typeWarnings.put(Integer.class, "should be an integer");
        typeWarnings.put(Long.class, "should be a long");
        typeWarnings.put(Boolean.class, "should be a boolean");
        typeWarnings.put(Double.class, "should be a double");
        typeWarnings.put(ItemStack.class, "should be an ItemStack");
        return typeWarnings;
    }

    private void logConfigFix(String key, String problem) {
        ServerSystem.getLog().warning("Fixing " + problem + " config entry '" + key + "' in file '" + this._file.getName() + "'");
    }

    private void loadDefaultConfig() throws FileNotFoundException {
        String filename = this._file.getName().toLowerCase();
        if (this._plugin.getResource(filename) != null) {
            this._originalCfg = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(this._plugin.getResource(filename)));
            return;
        }
        if (filename.equalsIgnoreCase("messages.yml") || filename.equalsIgnoreCase("mappings.yml")) {
            String language = this._configuration.getString("language", "english");
            String languageFile = "messages/" + language + "/" + filename;
            if (this._plugin.getResource(languageFile) != null) {
                this._originalCfg = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(this._plugin.getResource(languageFile)));
            } else {
                this._originalCfg = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(this._plugin.getResource("messages/english/" + filename)));
                ServerSystem.getLog().warning("Couldn't find messages file for language '" + language + "', using English instead");
            }
            return;
        }
        throw new FileNotFoundException("Couldn't find default config file '" + filename + "'!");
    }

    protected boolean validateAndFixConfig() {
        if (this._originalCfg == null) {
            return true;
        }
        boolean isValid = true;
        Map<Class<?>, String> typeWarnings = DefaultConfigReader.initializeTypeWarnings();
        ConfigurationSection defaultSection = this._originalCfg.getConfigurationSection("");
        if (defaultSection == null) {
            return true;
        }
        for (String key : defaultSection.getKeys(true)) {
            String warningMessage;
            Class<?> defaultType;
            Class<?> userType;
            if (key.toLowerCase(Locale.ROOT).contains("example")) continue;
            if (!this._configuration.isSet(key)) {
                this.logConfigFix(key, "missing");
                this._configuration.set(key, this._originalCfg.get(key));
                isValid = false;
                continue;
            }
            Object userValue = this._configuration.get(key);
            Object defaultValue = this._originalCfg.get(key);
            if (userValue == null || defaultValue == null || (userType = userValue.getClass()).isAssignableFrom(defaultType = defaultValue.getClass()) || (warningMessage = typeWarnings.get(defaultType)) == null) continue;
            this.logConfigFix(key, warningMessage);
            this._configuration.set(key, defaultValue);
            isValid = false;
        }
        return isValid;
    }

    private void createBackupAndSave() {
        String filename = this._file.getName();
        ServerSystem.getLog().warning("One or more errors with your '" + filename + "' file were found and fixed, a backup was made before saving");
        try {
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern("dd.MM.yyyy HH-mm-ss");
            LocalDateTime now = LocalDateTime.now();
            String date = dtf.format(now);
            File backupFile = Path.of("plugins", "ServerSystem", filename + ".backup-" + date).toFile();
            FileUtils.copyFile(this._file, backupFile);
            this.save();
            this.reload();
        }
        catch (IOException exception) {
            ServerSystem.getLog().log(Level.SEVERE, "Failed to create backup for '" + filename + "', changes are not saved!", exception);
        }
    }

    @Override
    public Object getObject(String path, Object def) {
        DefaultConfigReader configReader = this;
        if (this._newReader != null) {
            configReader = this._newReader;
        }
        configReader.ensureConfigHasValue(path);
        return configReader._configuration.get(path, def);
    }

    @Override
    public Object getObject(String path) {
        return this.getObject(path, null);
    }

    @Override
    public boolean getBoolean(String path, boolean def) {
        DefaultConfigReader configReader = this;
        if (this._newReader != null) {
            configReader = this._newReader;
        }
        configReader.ensureConfigHasValue(path);
        return configReader._configuration.getBoolean(path, def);
    }

    @Override
    public boolean getBoolean(String path) {
        return this.getBoolean(path, false);
    }

    @Override
    public String getString(String path, String def) {
        DefaultConfigReader configReader = this;
        if (this._newReader != null) {
            configReader = this._newReader;
        }
        configReader.ensureConfigHasValue(path);
        return configReader._configuration.getString(path, def);
    }

    @Override
    public String getString(String path) {
        return this.getString(path, null);
    }

    @Override
    public int getInt(String path, int def) {
        DefaultConfigReader configReader = this;
        if (this._newReader != null) {
            configReader = this._newReader;
        }
        configReader.ensureConfigHasValue(path);
        return configReader._configuration.getInt(path, def);
    }

    @Override
    public int getInt(String path) {
        return this.getInt(path, 0);
    }

    @Override
    public long getLong(String path, long def) {
        DefaultConfigReader configReader = this;
        if (this._newReader != null) {
            configReader = this._newReader;
        }
        configReader.ensureConfigHasValue(path);
        return configReader._configuration.getLong(path, def);
    }

    @Override
    public long getLong(String path) {
        return this.getLong(path, 0L);
    }

    @Override
    public double getDouble(String path, double def) {
        DefaultConfigReader configReader = this;
        if (this._newReader != null) {
            configReader = this._newReader;
        }
        configReader.ensureConfigHasValue(path);
        return configReader._configuration.getDouble(path, def);
    }

    @Override
    public double getDouble(String path) {
        return this.getDouble(path, 0.0);
    }

    @Override
    public ItemStack getItemStack(String path, ItemStack def) {
        DefaultConfigReader configReader = this;
        if (this._newReader != null) {
            configReader = this._newReader;
        }
        configReader.ensureConfigHasValue(path);
        return configReader._configuration.getItemStack(path, def);
    }

    @Override
    public ItemStack getItemStack(String path) {
        return this.getItemStack(path, null);
    }

    @Override
    public void set(String path, Object object) {
        DefaultConfigReader configReader = this;
        if (this._newReader != null) {
            configReader = this._newReader;
        }
        configReader._configuration.set(path, object);
    }

    @Override
    public void save() {
        DefaultConfigReader configReader = this;
        if (this._newReader != null) {
            configReader = this._newReader;
        }
        try {
            configReader._configuration.save(configReader._file);
        }
        catch (IOException exception) {
            ServerSystem.getLog().log(Level.SEVERE, "Failed to save configuration file '" + configReader._file.getName() + "'", exception);
        }
    }

    @Override
    public void reload() {
        DefaultConfigReader configReader = this;
        if (this._newReader != null) {
            configReader = this._newReader;
        }
        try {
            configReader._configuration.load(configReader._file);
        }
        catch (IOException | InvalidConfigurationException exception) {
            ServerSystem.getLog().log(Level.SEVERE, "Failed to reload configuration file '" + configReader._file.getName() + "'", exception);
        }
    }

    @Override
    public void load(File file) {
        try {
            this._newReader = new DefaultConfigReader(file, (Plugin)ServerSystem.Instance);
        }
        catch (Exception exception) {
            ServerSystem.getLog().log(Level.SEVERE, "Failed to load configuration file '" + file.getName() + "'", exception);
        }
    }

    @Override
    public ConfigurationSection getConfigurationSection(String path) {
        DefaultConfigReader configReader = this;
        if (this._newReader != null) {
            configReader = this._newReader;
        }
        configReader.ensureConfigHasValue(path);
        return configReader._configuration.getConfigurationSection(path);
    }

    @Override
    public boolean isConfigurationSection(String path) {
        DefaultConfigReader configReader = this;
        if (this._newReader != null) {
            configReader = this._newReader;
        }
        return configReader._configuration.isConfigurationSection(path);
    }

    private void ensureConfigHasValue(String path) {
        if (this._originalCfg == null) {
            return;
        }
        if (this._configuration.isSet(path) || !this._originalCfg.isSet(path)) {
            return;
        }
        String partialPath = this.findClosestExistingParentPath(path);
        if (partialPath.isEmpty()) {
            this.restoreConfigValue(path);
            return;
        }
        ConfigurationSection section = this._configuration.getConfigurationSection(partialPath);
        if (section == null) {
            this.restoreConfigValue(path);
            return;
        }
        section.set(path.substring(partialPath.length() + 1), this._originalCfg.get(path));
        this.saveAndReload();
    }

    private String findClosestExistingParentPath(String path) {
        if (!path.contains(".")) {
            return "";
        }
        String[] pathParts = path.split("\\.");
        StringBuilder currentPath = new StringBuilder();
        for (int i = 0; i < pathParts.length - 1; ++i) {
            if (i > 0) {
                currentPath.append(".");
            }
            currentPath.append(pathParts[i]);
            if (!this._configuration.isSet(currentPath.toString())) continue;
            return currentPath.toString();
        }
        return "";
    }

    private void restoreConfigValue(String path) {
        this._configuration.set(path, this._originalCfg.get(path));
        this.saveAndReload();
    }

    private void saveAndReload() {
        try {
            this._configuration.save(this._file);
            this._configuration.load(this._file);
        }
        catch (IOException | InvalidConfigurationException exception) {
            ServerSystem.getLog().log(Level.SEVERE, "Failed to save and reload configuration file '" + this._file.getName() + "'", exception);
        }
    }

    @Override
    public File getFile() {
        return this._file;
    }

    @Override
    public FileConfiguration getConfiguration() {
        return this._configuration;
    }
}

