/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.moderation.mute;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.managers.database.moderation.AbstractModerationDatabaseManager;
import me.testaccount666.serversystem.moderation.AbstractModeration;
import me.testaccount666.serversystem.moderation.AbstractModerationManager;
import me.testaccount666.serversystem.moderation.MuteModeration;

public abstract class AbstractSqlMuteManager
extends AbstractModerationManager {
    protected final AbstractModerationDatabaseManager databaseManager = ServerSystem.Instance.getModerationDatabaseManager();

    public AbstractSqlMuteManager(UUID ownerUuid) {
        super(ownerUuid);
    }

    @Override
    public void addModeration(AbstractModeration moderation) {
        if (!(moderation instanceof MuteModeration)) {
            throw new IllegalArgumentException("Moderation must be a MuteModeration");
        }
        MuteModeration muteModeration = (MuteModeration)moderation;
        try (Connection connection = this.databaseManager.getConnection();
             PreparedStatement statement = connection.prepareStatement("INSERT INTO Moderation (TargetUUID, SenderUUID, IssueTime, ExpireTime, Reason, Type) VALUES (?, ?, ?, ?, ?, ?)");){
            ServerSystem.getLog().info("Adding mute moderation for target '" + String.valueOf(moderation.targetUuid()) + "'");
            statement.setString(1, moderation.targetUuid().toString());
            statement.setString(2, moderation.senderUuid().toString());
            statement.setLong(3, moderation.issueTime());
            statement.setLong(4, moderation.expireTime());
            statement.setString(5, moderation.reason());
            statement.setString(6, muteModeration.isShadowMute() ? "SHADOW_MUTE" : "MUTE");
            statement.executeUpdate();
        }
        catch (SQLException exception) {
            throw new RuntimeException("Error adding mute moderation for target '" + String.valueOf(moderation.targetUuid()) + "'", exception);
        }
    }

    @Override
    public void removeModeration(AbstractModeration moderation) {
        try (Connection connection = this.databaseManager.getConnection();
             PreparedStatement statement = connection.prepareStatement("DELETE FROM Moderation WHERE TargetUUID = ? AND SenderUUID = ? AND IssueTime = ? AND (Type = 'MUTE' OR Type = 'SHADOW_MUTE')");){
            statement.setString(1, moderation.targetUuid().toString());
            statement.setString(2, moderation.senderUuid().toString());
            statement.setLong(3, moderation.issueTime());
            statement.executeUpdate();
        }
        catch (SQLException exception) {
            throw new RuntimeException("Error removing mute moderation for target '" + String.valueOf(moderation.targetUuid()) + "'", exception);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<AbstractModeration> getModerations() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Optional<AbstractModeration> getActiveModeration() {
        return this.getActiveMuteModerations().stream().map(AbstractModeration.class::cast).findFirst();
    }

    /*
     * Exception decompiling
     */
    public List<MuteModeration> getActiveMuteModerations() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean isPlayerMuted() {
        return !this.getActiveMuteModerations().isEmpty();
    }

    public boolean isPlayerShadowMuted() {
        return this.getActiveMuteModerations().stream().anyMatch(MuteModeration::isShadowMute);
    }
}

