/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.placeholderapi.executables;

import java.util.Optional;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.placeholderapi.Placeholder;
import me.testaccount666.serversystem.placeholderapi.PlaceholderManager;
import me.testaccount666.serversystem.userdata.CachedUser;
import me.testaccount666.serversystem.userdata.OfflineUser;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlaceholderExpansionWrapper
extends PlaceholderExpansion {
    @NotNull
    public String getIdentifier() {
        return "serversystem";
    }

    @NotNull
    public String getAuthor() {
        return (String)ServerSystem.Instance.getPluginMeta().getAuthors().getFirst();
    }

    @NotNull
    public String getVersion() {
        return ServerSystem.Instance.getPluginMeta().getVersion();
    }

    public boolean persist() {
        return true;
    }

    @Nullable
    public String onRequest(OfflinePlayer player, @NotNull String params) {
        if (params.isBlank()) {
            ServerSystem.getLog().warning("An invalid placeholder was requested!");
            return null;
        }
        String[] split = params.split("_");
        String identifier = split[0].toLowerCase();
        PlaceholderManager placeholderManager = ServerSystem.Instance.getPlaceholderManager();
        Optional<Placeholder> placeholderOptional = placeholderManager.getPlaceholder(identifier);
        if (placeholderOptional.isEmpty()) {
            ServerSystem.getLog().warning("An unknown placeholder was requested! '" + params + "'");
            return null;
        }
        Placeholder placeholder = placeholderOptional.get();
        String[] arguments = new String[]{};
        if (split.length > 1) {
            arguments = new String[split.length - 1];
            System.arraycopy(split, 1, arguments, 0, arguments.length);
        }
        if (player == null) {
            return placeholder.execute(null, identifier, arguments);
        }
        Optional<CachedUser> userOptional = ServerSystem.Instance.getUserManager().getUser(player.getUniqueId());
        if (userOptional.isEmpty()) {
            return null;
        }
        CachedUser cachedUser = userOptional.get();
        OfflineUser offlineUser = cachedUser.getOfflineUser();
        return placeholder.execute(offlineUser, identifier, arguments);
    }
}

