/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.userdata;

import java.util.UUID;
import me.testaccount666.serversystem.userdata.OfflineUser;
import me.testaccount666.serversystem.userdata.User;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class CachedUser {
    private static final long _STALE_TIME_MILLIS = 3600000L;
    private OfflineUser _offlineUser;
    private long _lastAccessTime;

    protected CachedUser(OfflineUser offlineUser) {
        this._offlineUser = offlineUser;
        this._lastAccessTime = System.currentTimeMillis();
    }

    public boolean isOnlineUser() {
        return this._offlineUser instanceof User;
    }

    public boolean isOfflineUser() {
        return !this.isOnlineUser();
    }

    public boolean isStale() {
        return System.currentTimeMillis() - this._lastAccessTime > 3600000L;
    }

    protected void updateLastAccessTime() {
        this._lastAccessTime = System.currentTimeMillis();
    }

    public void convertToOnlineUser() {
        Player player = Bukkit.getPlayer((UUID)this._offlineUser.getUuid());
        if (player == null) {
            throw new IllegalStateException("Cannot convert offline user to online user!");
        }
        this._offlineUser.save();
        this._offlineUser = new User(this._offlineUser);
    }

    public void convertToOfflineUser() {
        this._offlineUser.save();
        this._offlineUser = new OfflineUser(this._offlineUser);
    }

    public OfflineUser getOfflineUser() {
        return this._offlineUser;
    }

    public long getLastAccessTime() {
        return this._lastAccessTime;
    }
}

