/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.userdata;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import me.testaccount666.serversystem.commands.executables.teleportask.TeleportRequest;
import me.testaccount666.serversystem.userdata.CachedUser;
import me.testaccount666.serversystem.userdata.OfflineUser;
import net.kyori.adventure.text.Component;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class User
extends OfflineUser {
    protected final Set<CachedUser> messageListeners = new HashSet<CachedUser>();
    protected Player player;
    protected TeleportRequest teleportRequest;
    protected User replyUser;
    protected boolean isAfk = false;
    protected long afkSince;

    protected User(File userFile) {
        super(userFile);
    }

    protected User(OfflineUser offlineUser) {
        this(offlineUser.userFile);
    }

    @Override
    protected void loadBasicData() {
        super.loadBasicData();
        this.name = this.getPlayer().getName();
        this.lastSeen = System.currentTimeMillis();
        this.lastKnownIp = this.getPlayer().getAddress().getAddress().getHostAddress();
        this.save();
    }

    public Player getPlayer() {
        if (this.player == null) {
            this.player = (Player)super.getPlayer();
        }
        return this.player;
    }

    @Override
    public Optional<String> getName() {
        return Optional.of(this.getPlayer().getName());
    }

    public CommandSender getCommandSender() {
        return this.getPlayer();
    }

    public void sendMessage(String message) {
        this.getCommandSender().sendMessage(message);
        for (CachedUser listener : Collections.unmodifiableSet(this.messageListeners)) {
            if (listener.isOfflineUser()) {
                this.messageListeners.remove(listener);
                continue;
            }
            User user = (User)listener.getOfflineUser();
            user.sendMessage(message);
        }
    }

    public void sendMessage(Component component) {
        this.getCommandSender().sendMessage(component);
        for (CachedUser listener : Collections.unmodifiableSet(this.messageListeners)) {
            if (listener.isOfflineUser()) {
                this.messageListeners.remove(listener);
                continue;
            }
            User user = (User)listener.getOfflineUser();
            user.sendMessage(component);
        }
    }

    public void addMessageListener(CachedUser cachedUser) {
        this.messageListeners.add(cachedUser);
    }

    public void removeMessageListener(CachedUser cachedUser) {
        this.messageListeners.remove(cachedUser);
    }

    public void setAfk(boolean afk) {
        if (this.isAfk == afk) {
            return;
        }
        this.isAfk = afk;
        this.afkSince = afk ? System.currentTimeMillis() : 0L;
    }

    public void setTeleportRequest(TeleportRequest teleportRequest) {
        this.teleportRequest = teleportRequest;
    }

    public TeleportRequest getTeleportRequest() {
        return this.teleportRequest;
    }

    public void setReplyUser(User replyUser) {
        this.replyUser = replyUser;
    }

    public User getReplyUser() {
        return this.replyUser;
    }

    public boolean isAfk() {
        return this.isAfk;
    }

    public long getAfkSince() {
        return this.afkSince;
    }
}

