/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.userdata.listener;

import java.util.Optional;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.userdata.CachedUser;
import me.testaccount666.serversystem.userdata.OfflineUser;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;

public class UserQuitListener
implements Listener {
    @EventHandler(priority=EventPriority.HIGHEST)
    public void onUserQuit(PlayerQuitEvent event) {
        Optional<CachedUser> cachedUserOptional = ServerSystem.Instance.getUserManager().getUser(event.getPlayer().getUniqueId());
        if (cachedUserOptional.isEmpty()) {
            ServerSystem.getLog().warning("(UserQuitListener) User '" + event.getPlayer().getName() + "' is not cached! This should not happen!");
            return;
        }
        CachedUser user = cachedUserOptional.get();
        OfflineUser offlineUser = user.getOfflineUser();
        if (user.isOfflineUser()) {
            ServerSystem.getLog().warning("User '" + event.getPlayer().getName() + "' is not an online user! This should not happen!");
        }
        offlineUser.setLogoutPosition(event.getPlayer().getLocation());
        offlineUser.save();
        user.convertToOfflineUser();
    }
}

