/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.userdata.money;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import java.util.UUID;

public abstract class AbstractBankAccount {
    protected final UUID owner;
    protected final BigInteger accountId;

    public AbstractBankAccount(UUID owner, BigInteger accountId) {
        this.owner = owner;
        this.accountId = accountId;
    }

    public abstract BigDecimal getBalance();

    public abstract void setBalance(BigDecimal var1);

    public abstract void delete();

    public abstract void save();

    public void deposit(BigDecimal amount) {
        this.setBalance(this.getBalance().add(amount));
    }

    public void withdraw(BigDecimal amount) {
        this.setBalance(this.getBalance().subtract(amount));
    }

    public void transfer(BigDecimal amount, AbstractBankAccount targetAccount) {
        this.withdraw(amount);
        targetAccount.deposit(amount);
    }

    public boolean hasEnoughMoney(BigDecimal amount) {
        return this.getBalance().compareTo(amount) >= 0;
    }

    public abstract Map<UUID, BigDecimal> getTopTen();

    public UUID getOwner() {
        return this.owner;
    }

    public BigInteger getAccountId() {
        return this.accountId;
    }
}

