/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.userdata.money;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import java.util.UUID;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.userdata.ConsoleUser;
import me.testaccount666.serversystem.userdata.money.AbstractBankAccount;
import me.testaccount666.serversystem.userdata.money.DisabledBankAccount;
import me.testaccount666.serversystem.userdata.money.EconomyProvider;
import me.testaccount666.serversystem.userdata.money.MySqlBankAccount;
import me.testaccount666.serversystem.userdata.money.SqliteBankAccount;

public class ConsoleBankAccount
extends AbstractBankAccount {
    private final AbstractBankAccount _topTenFetcher;

    public ConsoleBankAccount() {
        super(ConsoleUser.CONSOLE_UUID, BigInteger.valueOf(-1L));
        EconomyProvider economyProvider = ServerSystem.Instance.getEconomyProvider();
        EconomyProvider.Type economyType = economyProvider.getEconomyType();
        this._topTenFetcher = switch (economyType) {
            case EconomyProvider.Type.MYSQL -> new MySqlBankAccount(this.getOwner(), this.getAccountId());
            case EconomyProvider.Type.SQLITE -> new SqliteBankAccount(this.getOwner(), this.getAccountId());
            default -> new DisabledBankAccount(this.getOwner(), this.getAccountId());
        };
    }

    @Override
    public BigDecimal getBalance() {
        return BigDecimal.valueOf(Double.MAX_VALUE);
    }

    @Override
    public void setBalance(BigDecimal balance) {
    }

    @Override
    public boolean hasEnoughMoney(BigDecimal amount) {
        return true;
    }

    @Override
    public void delete() {
    }

    @Override
    public void save() {
    }

    @Override
    public Map<UUID, BigDecimal> getTopTen() {
        return this._topTenFetcher.getTopTen();
    }
}

