/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.userdata.persistence;

import java.util.HashMap;
import java.util.Map;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.commands.executables.kit.manager.KitManager;
import me.testaccount666.serversystem.userdata.persistence.FieldHandler;
import org.bukkit.configuration.file.FileConfiguration;

public class KitMapFieldHandler
implements FieldHandler<Map<String, Long>> {
    @Override
    public void save(FileConfiguration config, String path, Map<String, Long> value) {
        config.set(path, null);
        if (value == null || value.isEmpty()) {
            return;
        }
        KitManager kitManager = ServerSystem.Instance.getKitManager();
        if (kitManager == null) {
            return;
        }
        value.forEach((kitName, cooldown) -> {
            if (!kitManager.kitExists((String)kitName)) {
                return;
            }
            config.set(path + "." + kitName, cooldown);
        });
    }

    @Override
    public Map<String, Long> load(FileConfiguration config, String path, Map<String, Long> defaultValue) {
        if (!config.isSet(path)) {
            return defaultValue;
        }
        if (ServerSystem.Instance.getKitManager() == null) {
            return defaultValue;
        }
        HashMap<String, Long> kitCooldowns = new HashMap<String, Long>();
        config.getConfigurationSection(path).getKeys(false).forEach(kitName -> kitCooldowns.put((String)kitName, config.getLong(path + "." + kitName)));
        return kitCooldowns;
    }
}

