/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.userdata.persistence;

import me.testaccount666.serversystem.userdata.persistence.FieldHandler;
import org.bukkit.configuration.file.FileConfiguration;

public class PrimitiveFieldHandler<T>
implements FieldHandler<T> {
    private final Class<T> _type;

    public PrimitiveFieldHandler(Class<T> type) {
        this._type = type;
    }

    @Override
    public void save(FileConfiguration config, String path, T value) {
        config.set(path, value);
    }

    @Override
    public T load(FileConfiguration config, String path, T defaultValue) {
        if (!config.isSet(path)) {
            return defaultValue;
        }
        Object value = config.get(path);
        if (this._type.isInstance(value)) {
            return (T)value;
        }
        if (this._type == Boolean.class || this._type == Boolean.TYPE) {
            return (T)Boolean.valueOf(config.getBoolean(path));
        }
        if (this._type == Integer.class || this._type == Integer.TYPE) {
            return (T)Integer.valueOf(config.getInt(path));
        }
        if (this._type == Long.class || this._type == Long.TYPE) {
            return (T)Long.valueOf(config.getLong(path));
        }
        if (this._type == Double.class || this._type == Double.TYPE) {
            return (T)Double.valueOf(config.getDouble(path));
        }
        if (this._type == String.class) {
            return (T)config.getString(path);
        }
        return defaultValue;
    }
}

