/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.userdata.persistence;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import me.testaccount666.serversystem.userdata.persistence.FieldHandler;
import org.bukkit.configuration.file.FileConfiguration;

public class UuidSetFieldHandler
implements FieldHandler<Set<UUID>> {
    @Override
    public void save(FileConfiguration config, String path, Set<UUID> uuids) {
        if (uuids == null || uuids.isEmpty()) {
            config.set(path, null);
            return;
        }
        List uuidStrings = uuids.stream().map(UUID::toString).collect(Collectors.toList());
        config.set(path, uuidStrings);
    }

    @Override
    public Set<UUID> load(FileConfiguration config, String path, Set<UUID> defaultValue) {
        if (!config.isSet(path)) {
            return defaultValue != null ? defaultValue : new HashSet();
        }
        List uuidStrings = config.getStringList(path);
        if (uuidStrings.isEmpty()) {
            return defaultValue != null ? defaultValue : new HashSet();
        }
        return uuidStrings.stream().map(UUID::fromString).collect(Collectors.toSet());
    }
}

