/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.utils;

import java.lang.reflect.Method;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public final class MethodAccessor {
    private MethodAccessor() {
    }

    public static <T> Consumer<T> createVoidAccessor(Class<T> targetClass, String methodName) {
        try {
            Method method = targetClass.getDeclaredMethod(methodName, new Class[0]);
            method.setAccessible(true);
            return instance -> {
                try {
                    method.invoke(instance, new Object[0]);
                }
                catch (ReflectiveOperationException exception) {
                    throw new RuntimeException("Failed to invoke method " + targetClass.getName() + "." + methodName, exception);
                }
            };
        }
        catch (NoSuchMethodException exception) {
            throw new RuntimeException("Failed to create void method accessor for " + targetClass.getName() + "." + methodName, exception);
        }
    }

    public static <T, P> BiConsumer<T, P> createVoidAccessor(Class<T> targetClass, String methodName, Class<P> paramType) {
        try {
            Method method = targetClass.getDeclaredMethod(methodName, paramType);
            method.setAccessible(true);
            return (instance, param) -> {
                try {
                    method.invoke(instance, param);
                }
                catch (ReflectiveOperationException exception) {
                    throw new RuntimeException("Failed to invoke method " + targetClass.getName() + "." + methodName, exception);
                }
            };
        }
        catch (NoSuchMethodException exception) {
            throw new RuntimeException("Failed to create void method accessor for " + targetClass.getName() + "." + methodName, exception);
        }
    }

    public static <T> BiConsumer<T, Object[]> createVoidAccessor(Class<T> targetClass, String methodName, Class<?> ... paramTypes) {
        try {
            Method method = targetClass.getDeclaredMethod(methodName, paramTypes);
            method.setAccessible(true);
            return (instance, params) -> {
                try {
                    method.invoke(instance, params);
                }
                catch (ReflectiveOperationException exception) {
                    throw new RuntimeException("Failed to invoke method " + targetClass.getName() + "." + methodName, exception);
                }
            };
        }
        catch (NoSuchMethodException exception) {
            throw new RuntimeException("Failed to create void method accessor for " + targetClass.getName() + "." + methodName, exception);
        }
    }

    public static <T, R> Function<T, R> createAccessor(Class<T> targetClass, String methodName, Class<R> returnType) {
        try {
            Method method = targetClass.getDeclaredMethod(methodName, new Class[0]);
            method.setAccessible(true);
            if (method.getReturnType() == Void.TYPE) {
                throw new IllegalArgumentException("Method returns void. Use createVoidAccessor instead.");
            }
            return instance -> {
                try {
                    Object result = method.invoke(instance, new Object[0]);
                    return result;
                }
                catch (ReflectiveOperationException exception) {
                    throw new RuntimeException("Failed to invoke method " + targetClass.getName() + "." + methodName, exception);
                }
            };
        }
        catch (NoSuchMethodException exception) {
            throw new RuntimeException("Failed to create method accessor for " + targetClass.getName() + "." + methodName, exception);
        }
    }

    public static <T, P, R> BiFunction<T, P, R> createAccessor(Class<T> targetClass, String methodName, Class<P> paramType, Class<R> returnType) {
        try {
            Method method = targetClass.getDeclaredMethod(methodName, paramType);
            method.setAccessible(true);
            if (method.getReturnType() == Void.TYPE) {
                throw new IllegalArgumentException("Method returns void. Use createVoidAccessor instead.");
            }
            return (instance, param) -> {
                try {
                    Object result = method.invoke(instance, param);
                    return result;
                }
                catch (ReflectiveOperationException exception) {
                    throw new RuntimeException("Failed to invoke method " + targetClass.getName() + "." + methodName, exception);
                }
            };
        }
        catch (NoSuchMethodException exception) {
            throw new RuntimeException("Failed to create method accessor for " + targetClass.getName() + "." + methodName, exception);
        }
    }

    public static <T, R> BiFunction<T, Object[], R> createAccessor(Class<T> targetClass, String methodName, Class<R> returnType, Class<?> ... paramTypes) {
        try {
            Method method = targetClass.getDeclaredMethod(methodName, paramTypes);
            method.setAccessible(true);
            if (method.getReturnType() == Void.TYPE) {
                throw new IllegalArgumentException("Method returns void. Use createVoidAccessor instead.");
            }
            return (instance, params) -> {
                try {
                    Object result = method.invoke(instance, params);
                    return result;
                }
                catch (ReflectiveOperationException exception) {
                    throw new RuntimeException("Failed to invoke method " + targetClass.getName() + "." + methodName, exception);
                }
            };
        }
        catch (NoSuchMethodException exception) {
            throw new RuntimeException("Failed to create method accessor for " + targetClass.getName() + "." + methodName, exception);
        }
    }
}

