/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.migration.plugins;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import me.testaccount666.migration.plugins.PluginMigrator;
import me.testaccount666.serversystem.ServerSystem;
import org.bukkit.plugin.Plugin;

public class MigratorRegistry {
    private final Map<String, PluginMigrator> _migrators = new HashMap<String, PluginMigrator>();

    public void registerMigrators() {
        try (ScanResult scanResult = new ClassGraph().enableAllInfo().acceptPackages(new String[]{"me.testaccount666.migration.plugins"}).scan();){
            List migratorClasses = scanResult.getClassesImplementing(PluginMigrator.class).loadClasses();
            for (Class migratorClass : migratorClasses) {
                try {
                    PluginMigrator migrator = (PluginMigrator)migratorClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    Plugin plugin = migrator.getPlugin();
                    if (plugin == null) continue;
                    this._migrators.put(plugin.getName().toLowerCase(), migrator);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
                    ServerSystem.getLog().log(Level.WARNING, "Failed to register migrator '" + migratorClass.getName() + "'", exception);
                }
            }
        }
    }

    public Optional<PluginMigrator> getMigrator(String pluginName) {
        return Optional.ofNullable(this._migrators.get(pluginName.toLowerCase()));
    }

    public Set<String> getMigrators() {
        return this._migrators.keySet();
    }
}

