/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.migration.plugins.essentials;

import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.User;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import me.testaccount666.migration.plugins.essentials.AbstractMigrator;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.userdata.CachedUser;
import me.testaccount666.serversystem.userdata.OfflineUser;
import me.testaccount666.serversystem.userdata.UserManager;
import me.testaccount666.serversystem.userdata.money.AbstractBankAccount;
import net.ess3.api.MaxMoneyException;
import net.ess3.api.events.UserBalanceUpdateEvent;
import org.bukkit.OfflinePlayer;

public class BalanceMigrator
extends AbstractMigrator {
    @Override
    public int migrateFrom() {
        int count = 0;
        UserManager userManager = this.userManager();
        Essentials essentials = this.essentials();
        Set uuids = essentials.getUsers().getAllUserUUIDs();
        for (UUID uuid : uuids) {
            Optional<CachedUser> userOptional = userManager.getUser(uuid);
            if (userOptional.isEmpty()) {
                ServerSystem.getLog().warning("Couldn't find user '" + String.valueOf(uuid) + "', skipping balance migration!");
                continue;
            }
            User essentialsUser = essentials.getUser(uuid);
            OfflineUser user = userOptional.get().getOfflineUser();
            AbstractBankAccount bankAccount = user.getBankAccount();
            bankAccount.setBalance(essentialsUser.getMoney());
            user.save();
            ++count;
        }
        return count;
    }

    @Override
    public int migrateTo() {
        int count = 0;
        UserManager userManager = this.userManager();
        for (OfflinePlayer player : this.offlinePlayers()) {
            UUID uuid = player.getUniqueId();
            Optional<CachedUser> userOptional = userManager.getUser(uuid);
            if (userOptional.isEmpty()) {
                ServerSystem.getLog().warning("Couldn't find user '" + String.valueOf(uuid) + "', skipping balance migration!");
                continue;
            }
            OfflineUser user = userOptional.get().getOfflineUser();
            AbstractBankAccount bankAccount = user.getBankAccount();
            Essentials essentials = this.essentials();
            this.ensureUserDataExists(uuid);
            User essentialsUser = essentials.getUser(uuid);
            try {
                essentialsUser.setMoney(bankAccount.getBalance(), UserBalanceUpdateEvent.Cause.SPECIAL);
                ++count;
            }
            catch (MaxMoneyException exception) {
                String userName = user.getName().orElse("Unknown");
                ServerSystem.getLog().log(Level.WARNING, "Couldn't migrate balance for '" + String.valueOf(uuid) + "' (" + userName + ") with balance '" + String.valueOf(bankAccount.getBalance()) + "'", exception);
            }
        }
        return count;
    }
}

