/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.migration.plugins.essentials;

import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import me.testaccount666.migration.plugins.PluginMigrator;
import me.testaccount666.migration.plugins.essentials.AbstractMigrator;
import me.testaccount666.migration.plugins.essentials.BalanceMigrator;
import me.testaccount666.migration.plugins.essentials.HomeMigrator;
import me.testaccount666.migration.plugins.essentials.MuteMigrator;
import me.testaccount666.migration.plugins.essentials.PlayerStateMigrator;
import me.testaccount666.migration.plugins.essentials.WarpMigrator;
import me.testaccount666.serversystem.ServerSystem;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class EssentialsMigrator
implements PluginMigrator {
    private final Function<Void, AbstractMigrator> _warpMigrator = ignored -> new WarpMigrator();
    private final Function<Void, AbstractMigrator> _homeMigrator = ignored -> new HomeMigrator();
    private final Function<Void, AbstractMigrator> _balanceMigrator = ignored -> new BalanceMigrator();
    private final Function<Void, AbstractMigrator> _stateMigrator = ignored -> new PlayerStateMigrator();
    private final Function<Void, AbstractMigrator> _muteMigrator = ignored -> new MuteMigrator();

    @Override
    public Plugin getPlugin() {
        return Bukkit.getPluginManager().getPlugin("Essentials");
    }

    @Override
    public void migrateFrom() {
        Logger logger = ServerSystem.getLog();
        logger.info("Starting migration of Essentials data!");
        try {
            int warpCount = this._warpMigrator.apply(null).migrateFrom();
            logger.info("Migrated " + warpCount + " warps!");
            int homeCount = this._homeMigrator.apply(null).migrateFrom();
            logger.info("Migrated " + homeCount + " homes!");
            int balanceCount = this._balanceMigrator.apply(null).migrateFrom();
            logger.info("Migrated " + balanceCount + " balances!");
            int stateCount = this._stateMigrator.apply(null).migrateFrom();
            logger.info("Migrated " + stateCount + " player states!");
            int muteCount = this._muteMigrator.apply(null).migrateFrom();
            logger.info("Migrated " + muteCount + " mutes!");
            logger.info("Finished migration of Essentials data!");
        }
        catch (Throwable throwable) {
            logger.log(Level.SEVERE, "An error occurred while migrating Essentials data!", throwable);
        }
    }

    @Override
    public void migrateTo() {
        Logger logger = ServerSystem.getLog();
        logger.info("Starting migration to Essentials!");
        try {
            int warpCount = this._warpMigrator.apply(null).migrateTo();
            logger.info("Migrated " + warpCount + " warps!");
            int homeCount = this._homeMigrator.apply(null).migrateTo();
            logger.info("Migrated " + homeCount + " homes!");
            int balanceCount = this._balanceMigrator.apply(null).migrateTo();
            logger.info("Migrated " + balanceCount + " balances!");
            int stateCount = this._stateMigrator.apply(null).migrateTo();
            logger.info("Migrated " + stateCount + " player states!");
            int muteCount = this._muteMigrator.apply(null).migrateTo();
            logger.info("Migrated " + muteCount + " mutes!");
            logger.info("Finished migration to Essentials!");
        }
        catch (Throwable throwable) {
            logger.log(Level.SEVERE, "An error occurred while migrating to Essentials!", throwable);
        }
    }
}

