/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.migration.plugins.essentials;

import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.commands.WarpNotFoundException;
import java.util.logging.Level;
import me.testaccount666.migration.plugins.essentials.AbstractMigrator;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.commands.executables.warp.manager.Warp;
import me.testaccount666.serversystem.commands.executables.warp.manager.WarpManager;
import org.bukkit.Location;

public class WarpMigrator
extends AbstractMigrator {
    @Override
    public int migrateFrom() {
        WarpManager warpManager = ServerSystem.Instance.getRegistry().getService(WarpManager.class);
        Essentials essentials = this.essentials();
        int count = 0;
        for (String warpName : essentials.getWarps().getList()) {
            try {
                Location location = essentials.getWarps().getWarp(warpName);
                warpManager.addWarp(warpName, location);
                ++count;
            }
            catch (WarpNotFoundException | IllegalArgumentException exception) {
                ServerSystem.getLog().log(Level.WARNING, "Couldn't migrate warp '" + warpName + "'", exception);
            }
        }
        return count;
    }

    @Override
    public int migrateTo() {
        WarpManager warpManager = ServerSystem.Instance.getRegistry().getService(WarpManager.class);
        Essentials essentials = this.essentials();
        int count = 0;
        for (Warp warp : warpManager.getWarps()) {
            try {
                String warpName = warp.getDisplayName();
                Location location = warp.getLocation();
                essentials.getWarps().setWarp(warpName, location);
                ++count;
            }
            catch (Exception exception) {
                ServerSystem.getLog().log(Level.WARNING, "Couldn't migrate warp '" + warp.getDisplayName() + "'", exception);
            }
        }
        return count;
    }
}

