/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.Logger;
import me.testaccount666.migration.LegacyDataMigrator;
import me.testaccount666.migration.plugins.MigratorRegistry;
import me.testaccount666.serversystem.ServiceRegistry;
import me.testaccount666.serversystem.clickablesigns.SignManager;
import me.testaccount666.serversystem.commands.executables.kit.manager.KitManager;
import me.testaccount666.serversystem.commands.executables.warp.manager.WarpManager;
import me.testaccount666.serversystem.commands.management.CommandManager;
import me.testaccount666.serversystem.commands.management.CommandReplacer;
import me.testaccount666.serversystem.listener.management.ListenerManager;
import me.testaccount666.serversystem.managers.config.ConfigurationManager;
import me.testaccount666.serversystem.managers.database.AbstractDatabaseManager;
import me.testaccount666.serversystem.managers.database.economy.AbstractEconomyDatabaseManager;
import me.testaccount666.serversystem.managers.database.economy.MySqlEconomyDatabaseManager;
import me.testaccount666.serversystem.managers.database.economy.SqliteEconomyDatabaseManager;
import me.testaccount666.serversystem.managers.database.moderation.AbstractModerationDatabaseManager;
import me.testaccount666.serversystem.managers.database.moderation.MySqlModerationDatabaseManager;
import me.testaccount666.serversystem.managers.database.moderation.SqliteModerationDatabaseManager;
import me.testaccount666.serversystem.placeholderapi.PlaceholderApiSupport;
import me.testaccount666.serversystem.placeholderapi.PlaceholderManager;
import me.testaccount666.serversystem.updates.UpdateManager;
import me.testaccount666.serversystem.userdata.CachedUser;
import me.testaccount666.serversystem.userdata.OfflineUser;
import me.testaccount666.serversystem.userdata.UserManager;
import me.testaccount666.serversystem.userdata.money.EconomyProvider;
import me.testaccount666.serversystem.userdata.money.vault.EconomyVaultAPI;
import me.testaccount666.serversystem.utils.Version;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class ServerSystem
extends JavaPlugin {
    public static final Version MINIMUM_MINECRAFT_VERSION = new Version("1.21");
    public static final Version CURRENT_VERSION = new Version("3.2.1");
    public static ServerSystem Instance;
    private static Logger _Log;
    private final ServiceRegistry _registry = new ServiceRegistry();

    public static Version getServerVersion() {
        String version = Bukkit.getMinecraftVersion();
        ServerSystem.getLog().log(Level.FINE, "Server version: " + version);
        return new Version(version);
    }

    public void onEnable() {
        LegacyDataMigrator migrator;
        Instance = this;
        _Log = this.getLogger();
        Version minecraftVersion = ServerSystem.getServerVersion();
        if (minecraftVersion.compareTo(MINIMUM_MINECRAFT_VERSION) < 0) {
            ServerSystem.getLog().warning("You're running an unsupported/legacy version of Minecraft! Please update to at least " + MINIMUM_MINECRAFT_VERSION.getVersion() + "!");
        }
        if ((migrator = new LegacyDataMigrator()).isLegacyDataPresent()) {
            ServerSystem.getLog().log(Level.INFO, "Legacy data detected. Attempting to migrate...");
            migrator.prepareMigration();
        }
        File previousVersionFile = new File(this.getDataFolder(), "previousVersion.yml");
        YamlConfiguration previousVersionConfig = YamlConfiguration.loadConfiguration((File)previousVersionFile);
        previousVersionConfig.set("previousVersion", (Object)CURRENT_VERSION.toString());
        try {
            previousVersionConfig.save(previousVersionFile);
        }
        catch (IOException exception) {
            throw new RuntimeException("Error updating 'previousVersion'", exception);
        }
        try {
            this.initialize();
        }
        catch (Exception exception) {
            ServerSystem.getLog().log(Level.SEVERE, "Failed to initialize the plugin", exception);
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        ConfigurationManager configManager = this.getRegistry().getService(ConfigurationManager.class);
        this.getRegistry().registerService(UpdateManager.class, new UpdateManager(this, configManager)).start();
        Bukkit.getScheduler().runTaskLater((Plugin)this, migrator::migrateLegacyData, 1L);
        Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
            ServiceRegistry registry = this.getRegistry();
            registry.getServiceOptional(CommandManager.class).ifPresent(CommandManager::registerCommands);
            registry.getServiceOptional(ListenerManager.class).ifPresent(ListenerManager::registerListeners);
            registry.getServiceOptional(PlaceholderManager.class).ifPresent(PlaceholderManager::registerPlaceholders);
            registry.getServiceOptional(CommandReplacer.class).ifPresent(CommandReplacer::replaceCommands);
        }, 2L);
    }

    private void initialize() throws Exception {
        ServiceRegistry registry = this.getRegistry();
        ConfigurationManager configManager = new ConfigurationManager((Plugin)this);
        registry.registerService(ConfigurationManager.class, configManager).loadAllConfigs();
        String moderationType = configManager.getModerationConfig().getString("Moderation.StorageType.Value");
        AbstractModerationDatabaseManager moderationDbManager = switch (moderationType.toLowerCase()) {
            case "sqlite" -> new SqliteModerationDatabaseManager(this.getDataFolder());
            case "mysql" -> new MySqlModerationDatabaseManager(configManager.getModerationConfig());
            default -> throw new IllegalStateException("Unsupported moderation storage: " + moderationType + " - Supported values: sqlite, mysql");
        };
        registry.registerService(AbstractModerationDatabaseManager.class, moderationDbManager);
        MigratorRegistry migratorRegistry = new MigratorRegistry();
        registry.registerService(MigratorRegistry.class, migratorRegistry).registerMigrators();
        PlaceholderApiSupport.registerPlaceholders();
        moderationDbManager.initialize();
        String economyStorageType = configManager.getEconomyConfig().getString("Economy.StorageType.Value");
        AbstractEconomyDatabaseManager economyDbManager = switch (economyStorageType.toLowerCase()) {
            case "sqlite" -> new SqliteEconomyDatabaseManager(this.getDataFolder());
            case "mysql" -> new MySqlEconomyDatabaseManager(configManager.getEconomyConfig());
            default -> throw new IllegalStateException("Unsupported economy storage: " + economyStorageType + " - Supported values: sqlite, mysql");
        };
        registry.registerService(AbstractEconomyDatabaseManager.class, economyDbManager);
        CommandManager commandManager = new CommandManager(configManager.getCommandsConfig());
        registry.registerService(CommandManager.class, commandManager);
        registry.registerService(ListenerManager.class, new ListenerManager(commandManager));
        registry.registerService(PlaceholderManager.class, new PlaceholderManager());
        registry.registerService(EconomyProvider.class, new EconomyProvider(configManager.getEconomyConfig()));
        registry.registerService(UserManager.class, new UserManager());
        registry.registerService(KitManager.class, new KitManager());
        registry.registerService(CommandReplacer.class, new CommandReplacer());
        int migratorCount = migratorRegistry.getMigrators().size();
        if (migratorCount == 0 && configManager.getEconomyConfig().getBoolean("Economy.HookIntoVault") && EconomyVaultAPI.isVaultInstalled()) {
            EconomyVaultAPI.initialize();
        }
        if (migratorCount > 0) {
            ServerSystem.getLog().info("Not hooking into Vault since we found data migrators!");
        }
        Bukkit.getScheduler().runTask((Plugin)this, () -> {
            File warpFile = Path.of(this.getDataFolder().getPath(), "data", "warps.yml").toFile();
            YamlConfiguration warpConfig = YamlConfiguration.loadConfiguration((File)warpFile);
            registry.registerService(WarpManager.class, new WarpManager((FileConfiguration)warpConfig, warpFile));
            registry.registerService(SignManager.class, new SignManager()).loadSignTypes();
        });
    }

    public void onDisable() {
        ServiceRegistry registry = this.getRegistry();
        registry.getServiceOptional(UserManager.class).ifPresent(this::saveAllUsers);
        registry.getServiceOptional(CommandManager.class).ifPresent(CommandManager::unregisterCommands);
        registry.getServiceOptional(ListenerManager.class).ifPresent(ListenerManager::unregisterListeners);
        PlaceholderApiSupport.unregisterPlaceholders();
        registry.getServiceOptional(AbstractEconomyDatabaseManager.class).ifPresent(AbstractDatabaseManager::shutdown);
        registry.getServiceOptional(AbstractModerationDatabaseManager.class).ifPresent(AbstractDatabaseManager::shutdown);
        registry.clearServices();
    }

    private void saveAllUsers(UserManager userManager) {
        userManager.getCachedUsers().stream().map(CachedUser::getOfflineUser).forEach(OfflineUser::save);
    }

    public static Logger getLog() {
        return _Log;
    }

    public ServiceRegistry getRegistry() {
        return this._registry;
    }
}

