/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.clickablesigns;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.clickablesigns.SignConfigurator;
import me.testaccount666.serversystem.clickablesigns.SignManager;
import me.testaccount666.serversystem.clickablesigns.SignType;
import me.testaccount666.serversystem.clickablesigns.cost.CostType;
import me.testaccount666.serversystem.clickablesigns.util.SignUtils;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.block.Sign;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public abstract class AbstractSignConfigurator
implements SignConfigurator {
    protected abstract String getCreatePermissionNode();

    protected abstract SignType getSignType();

    protected abstract boolean validateConfiguration(User var1, Sign var2, YamlConfiguration var3);

    protected abstract void addSignSpecificConfiguration(User var1, Sign var2, FileConfiguration var3);

    protected abstract String getSuccessMessageKey();

    @Override
    public void execute(User user, Sign sign) {
        if (!PermissionManager.hasPermission(user, this.getCreatePermissionNode(), false)) {
            MessageBuilder.general("NoPermission", user).postModifier(message -> message.replace("<PERMISSION>", PermissionManager.getPermission(this.getCreatePermissionNode()))).build();
            return;
        }
        File signFile = SignUtils.getSignFile(sign.getLocation());
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)signFile);
        config.set("Key", (Object)this.getSignType().name());
        config.set("Cost.Type", (Object)CostType.NONE.name());
        config.set("Cost.Amount", (Object)0);
        if (!this.validateConfiguration(user, sign, config)) {
            return;
        }
        this.addSignSpecificConfiguration(user, sign, (FileConfiguration)config);
        try {
            config.save(signFile);
        }
        catch (IOException exception) {
            user.sendMessage(exception.getMessage());
            ServerSystem.getLog().log(Level.SEVERE, "Failed to save sign configuration " + signFile.getAbsolutePath(), exception);
            return;
        }
        ServerSystem.Instance.getRegistry().getService(SignManager.class).addSignType(sign.getLocation(), this.getSignType());
        MessageBuilder.sign(this.getSuccessMessageKey(), user).build();
    }
}

